/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.category.item;

import com.github.franckyi.ibeeditor.client.screen.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.class_1294;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private class_2499 potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, this.getTag().method_10558("Potion"), this.getCustomPotionColor(), p -> this.getTag().method_10582("Potion", p), this::setCustomPotionColor));
        this.getTag().method_10554("custom_potion_effects", 10).stream().map(class_2487.class::cast).map(this::createPotionEffectEntry).forEach(this.getEntries()::add);
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getTag().method_10573("CustomPotionColor", 3) ? this.getTag().method_10550("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().method_10569("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().method_10551("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(class_2487 tag) {
        if (tag != null) {
            String id = tag.method_10558("id");
            int amplifier = tag.method_10550("amplifier");
            int duration = tag.method_10573("duration", 3) ? tag.method_10550("duration") : 1;
            boolean ambient = tag.method_10577("ambient");
            boolean showParticles = !tag.method_10573("show_particles", 1) || tag.method_10577("show_particles");
            boolean showIcon = tag.method_10577("show_icon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        return new PotionEffectEntryModel(this, class_7923.field_41174.method_10221((Object)class_1294.field_5904).toString(), 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply() {
        this.potionEffectList = new class_2499();
        super.apply();
        if (!this.potionEffectList.isEmpty()) {
            this.getOrCreateTag().method_10566("custom_potion_effects", (class_2520)this.potionEffectList);
        } else if (this.getOrCreateTag().method_10545("custom_potion_effects")) {
            this.getOrCreateTag().method_10551("custom_potion_effects");
        }
    }

    private void addPotionEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", id);
        tag.method_10569("amplifier", amplifier);
        tag.method_10569("duration", duration);
        tag.method_10556("ambient", ambient);
        tag.method_10556("show_particles", showParticles);
        tag.method_10556("show_icon", showIcon);
        this.potionEffectList.add((Object)tag);
    }
}

