/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.util.texteditor;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.ibeeditor.client.util.texteditor.Formatting;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TextEditorOutputFormatter {
    private final class_5250 rootText;
    private int currentFormattingIndex;
    private int previousTextIndex;
    private List<Formatting> currentFormattings;

    public TextEditorOutputFormatter(class_5250 rootText) {
        this.rootText = rootText;
    }

    public void format(String text, int firstCharacterIndex, List<Formatting> formattings) {
        int currentTextIndex;
        this.initFormattingsForIndex(formattings, firstCharacterIndex);
        for (currentTextIndex = 1; currentTextIndex <= text.length(); ++currentTextIndex) {
            ++this.currentFormattingIndex;
            List<Formatting> changedFormattings = this.getChangedFormattingsForCurrentIndex(formattings);
            if (changedFormattings.isEmpty()) continue;
            this.appendText(text.substring(this.previousTextIndex, currentTextIndex));
            changedFormattings.forEach(formatting -> {
                if (formatting.getStart() == this.currentFormattingIndex) {
                    this.currentFormattings.add((Formatting)formatting);
                } else {
                    this.currentFormattings.remove(formatting);
                }
            });
            this.previousTextIndex = currentTextIndex;
        }
        if (this.previousTextIndex != currentTextIndex - 1) {
            this.appendText(text.substring(this.previousTextIndex, currentTextIndex - 1));
        }
    }

    private void initFormattingsForIndex(List<Formatting> formattings, int index) {
        this.currentFormattingIndex = index;
        this.currentFormattings = formattings.stream().filter(formatting -> formatting.getStart() <= this.currentFormattingIndex && formatting.getEnd() > this.currentFormattingIndex).collect(Collectors.toList());
    }

    private List<Formatting> getChangedFormattingsForCurrentIndex(List<Formatting> formattings) {
        return formattings.stream().filter(formatting -> formatting.getStart() == this.currentFormattingIndex || formatting.getEnd() == this.currentFormattingIndex).toList();
    }

    private void appendText(String s) {
        class_5250 text = GuapiHelper.text(s);
        this.currentFormattings.forEach(formatting -> formatting.apply(text));
        this.rootText.method_10852((class_2561)text);
    }

    public class_5250 getText() {
        return this.rootText;
    }
}

