/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.network;

import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorRequest;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorResponse;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorUpdate;
import com.github.franckyi.ibeeditor.common.network.InventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.ItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.PacketSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public final class PlayerInventoryItemEditorPacket
extends InventoryItemEditorPacket {

    public static class Update
    extends InventoryItemEditorPacket.Update<RequestData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, class_1799 itemStack) {
            super((RequestData)response.getRequestData(), new ItemEditorPacket.ResponseData(itemStack));
        }
    }

    public static class Response
    extends InventoryItemEditorPacket.Response<RequestData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ItemEditorPacket.ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ItemEditorPacket.ResponseData> getResponseDataSerializer() {
                return ItemEditorPacket.ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, class_1799 item) {
            super(request, hasPermission, new ItemEditorPacket.ResponseData(item));
        }
    }

    public static class Request
    extends InventoryItemEditorPacket.Request<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, int slot, boolean creativeInventoryScreen) {
            super(editorType, new RequestData(slot, creativeInventoryScreen));
        }

        public boolean isCreativeInventoryScreen() {
            return ((RequestData)this.getRequestData()).isCreativeInventoryScreen();
        }
    }

    public static class RequestData
    extends InventoryItemEditorPacket.RequestData {
        public static final PacketSerializer<RequestData> SERIALIZER = new InventoryItemEditorPacket.RequestData.Serializer<RequestData>(){

            @Override
            public void write(RequestData obj, class_2540 buf) {
                super.write(obj, buf);
                buf.method_52964(obj.isCreativeInventoryScreen());
            }

            @Override
            public void read(RequestData obj, class_2540 buf) {
                super.read(obj, buf);
                obj.setCreativeInventoryScreen(buf.readBoolean());
            }

            @Override
            public RequestData createInstance() {
                return new RequestData();
            }
        };
        private boolean creativeInventoryScreen;

        private RequestData() {
        }

        public RequestData(int slot, boolean creativeInventoryScreen) {
            super(slot);
            this.creativeInventoryScreen = creativeInventoryScreen;
        }

        public boolean isCreativeInventoryScreen() {
            return this.creativeInventoryScreen;
        }

        protected void setCreativeInventoryScreen(boolean creativeInventoryScreen) {
            this.creativeInventoryScreen = creativeInventoryScreen;
        }
    }
}

