/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.warnings;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.ETFConfig;

public abstract class ETFConfigWarning {
    public abstract boolean isConditionMet();

    public abstract String getTitle();

    public abstract String getSubTitle();

    public abstract String getID();

    public abstract void testWarningAndApplyFixIfEnabled();

    protected boolean isEnabled() {
        return this.isConditionMet() && !ETFConfig.getInstance().ignoredConfigs2.contains(this.getID());
    }

    public abstract boolean doesShowDisableButton();

    static class Simple
    extends ETFConfigWarning {
        public final String TITLE_TRANSLATION_KEY;
        public final String SUB_TITLE_TRANSLATION_KEY;
        public final String ID;
        private final Supplier<Boolean> CONDITION;
        @Nullable
        private final Runnable FIX;

        Simple(String id, Supplier<Boolean> condition, String title_translation_key, String sub_title_translation_key, @Nullable Runnable fix) {
            this.ID = id;
            this.CONDITION = condition;
            this.TITLE_TRANSLATION_KEY = title_translation_key;
            this.SUB_TITLE_TRANSLATION_KEY = sub_title_translation_key;
            this.FIX = fix;
        }

        Simple(String id, String modName, String title_translation_key, String sub_title_translation_key, @Nullable Runnable fix) {
            this.ID = id;
            this.CONDITION = () -> ETFVersionDifferenceHandler.isThisModLoaded(modName);
            this.TITLE_TRANSLATION_KEY = title_translation_key;
            this.SUB_TITLE_TRANSLATION_KEY = sub_title_translation_key;
            this.FIX = fix;
        }

        @Override
        public boolean isConditionMet() {
            return this.CONDITION.get();
        }

        @Override
        public String getTitle() {
            return this.TITLE_TRANSLATION_KEY;
        }

        @Override
        public String getSubTitle() {
            return this.SUB_TITLE_TRANSLATION_KEY;
        }

        @Override
        public String getID() {
            return this.ID;
        }

        @Override
        public void testWarningAndApplyFixIfEnabled() {
            if (this.FIX != null && this.isEnabled()) {
                this.FIX.run();
            }
        }

        @Override
        public boolean doesShowDisableButton() {
            return this.FIX != null;
        }
    }
}

