/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.fabric.common.config;

import com.viaversion.viaversion.util.Config;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VFConfig
extends Config {
    public static final String ENABLE_CLIENT_SIDE = "enable-client-side";
    public static final String CLIENT_SIDE_VERSION = "client-side-version";
    public static final String CLIENT_SIDE_FORCE_DISABLE = "client-side-force-disable";
    public static final String HIDE_BUTTON = "hide-button";

    public VFConfig(File configFile) {
        super(configFile);
        this.reload();
    }

    public URL getDefaultConfigURL() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("assets/viafabric/config.yml");
    }

    protected void handleConfig(Map<String, Object> map) {
    }

    public List<String> getUnsupportedOptions() {
        return Collections.emptyList();
    }

    public boolean isClientSideEnabled() {
        return this.getBoolean(ENABLE_CLIENT_SIDE, false);
    }

    public void setClientSideEnabled(boolean val) {
        this.set(ENABLE_CLIENT_SIDE, val);
    }

    public int getClientSideVersion() {
        return this.getInt(CLIENT_SIDE_VERSION, -1);
    }

    public void setClientSideVersion(int val) {
        this.set(CLIENT_SIDE_VERSION, val);
    }

    public Collection<?> getClientSideForceDisable() {
        return (List)this.get(CLIENT_SIDE_FORCE_DISABLE, List.class, Collections.emptyList());
    }

    public void setHideButton(boolean val) {
        this.set(HIDE_BUTTON, val);
    }

    public boolean isHideButton() {
        return this.getBoolean(HIDE_BUTTON, false);
    }

    public boolean isForcedDisable(String line) {
        return this.getClientSideForceDisable().contains(line);
    }
}

