/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.fabric.common.handler;

import com.viaversion.fabric.common.handler.PipelineReorderEvent;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.exception.CancelCodecException;
import com.viaversion.viaversion.exception.CancelDecoderException;
import com.viaversion.viaversion.exception.InformativeException;
import com.viaversion.viaversion.util.PipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

@ChannelHandler.Sharable
public class FabricDecodeHandler
extends MessageToMessageDecoder<ByteBuf> {
    private final UserConnection info;

    public FabricDecodeHandler(UserConnection info) {
        this.info = info;
    }

    public UserConnection getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> out) throws Exception {
        if (!this.info.checkIncomingPacket()) {
            throw CancelDecoderException.generate(null);
        }
        if (!this.info.shouldTransformPacket()) {
            out.add(bytebuf.retain());
            return;
        }
        ByteBuf transformedBuf = ctx.alloc().buffer().writeBytes(bytebuf);
        try {
            this.info.transformIncoming(transformedBuf, CancelDecoderException::generate);
            out.add(transformedBuf.retain());
        }
        finally {
            transformedBuf.release();
        }
    }

    private void reorder(ChannelHandlerContext ctx) {
        int decoderIndex = ctx.pipeline().names().indexOf("decompress");
        if (decoderIndex == -1) {
            return;
        }
        if (decoderIndex > ctx.pipeline().names().indexOf("via-decoder")) {
            ChannelHandler encoder = ctx.pipeline().get("via-encoder");
            ChannelHandler decoder = ctx.pipeline().get("via-decoder");
            ctx.pipeline().remove(encoder);
            ctx.pipeline().remove(decoder);
            ctx.pipeline().addAfter("compress", "via-encoder", encoder);
            ctx.pipeline().addAfter("decompress", "via-decoder", decoder);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (PipelineUtil.containsCause((Throwable)cause, CancelCodecException.class)) {
            return;
        }
        super.exceptionCaught(ctx, cause);
        if (PipelineUtil.containsCause((Throwable)cause, InformativeException.class) && this.info.getProtocolInfo().getState() != State.HANDSHAKE || Via.getManager().debugHandler().enabled()) {
            cause.printStackTrace();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        boolean kryptonReorder = false;
        switch (evt.toString()) {
            case "COMPRESSION_THRESHOLD_UPDATED": 
            case "COMPRESSION_ENABLED": {
                kryptonReorder = true;
            }
        }
        if (evt instanceof PipelineReorderEvent || kryptonReorder) {
            this.reorder(ctx);
        }
        super.userEventTriggered(ctx, evt);
    }
}

