/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.fabric.common.provider;

import com.google.common.primitives.Ints;
import com.viaversion.fabric.common.AddressParser;
import com.viaversion.fabric.common.config.VFConfig;
import com.viaversion.fabric.common.platform.NativeVersionProvider;
import com.viaversion.fabric.common.util.ProtocolUtils;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.exception.CancelException;
import com.viaversion.viaversion.protocols.base.BaseProtocol1_16;
import com.viaversion.viaversion.protocols.base.BaseProtocol1_7;
import com.viaversion.viaversion.protocols.base.BaseVersionProvider;
import com.viaversion.viaversion.protocols.base.ClientboundStatusPackets;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import net.fabricmc.loader.api.FabricLoader;

public abstract class AbstractFabricVersionProvider
extends BaseVersionProvider {
    private int[] multiconnectSupportedVersions = null;

    public AbstractFabricVersionProvider() {
        this.multiconnectIntegration();
    }

    private void multiconnectIntegration() {
        if (!FabricLoader.getInstance().isModLoaded("multiconnect")) {
            return;
        }
        try {
            Method isMulticonnectBeta;
            Class<?> mcApiClass = Class.forName("net.earthcomputer.multiconnect.api.MultiConnectAPI");
            Class<?> iProtocolClass = Class.forName("net.earthcomputer.multiconnect.api.IProtocol");
            Object mcApiInstance = mcApiClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            List protocols = (List)mcApiClass.getMethod("getSupportedProtocols", new Class[0]).invoke(mcApiInstance, new Object[0]);
            Method getValue = iProtocolClass.getMethod("getValue", new Class[0]);
            try {
                isMulticonnectBeta = iProtocolClass.getMethod("isMulticonnectBeta", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                isMulticonnectBeta = null;
            }
            TreeSet<Integer> vers = new TreeSet<Integer>();
            for (Object protocol : protocols) {
                if (isMulticonnectBeta != null && ((Boolean)isMulticonnectBeta.invoke(protocol, new Object[0])).booleanValue()) continue;
                vers.add((Integer)getValue.invoke(protocol, new Object[0]));
            }
            this.multiconnectSupportedVersions = vers.stream().mapToInt(Integer::intValue).toArray();
            this.getLogger().info("ViaFabric will integrate with multiconnect");
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public int getClosestServerProtocol(UserConnection connection) throws Exception {
        if (connection.isClientSide()) {
            ProtocolInfo info = Objects.requireNonNull(connection.getProtocolInfo());
            if (!this.getConfig().isClientSideEnabled()) {
                return info.getProtocolVersion();
            }
            int serverVer = this.getConfig().getClientSideVersion();
            SocketAddress addr = connection.getChannel().remoteAddress();
            if (addr instanceof InetSocketAddress) {
                AddressParser parser = new AddressParser();
                Integer addrVersion = parser.parse((String)((InetSocketAddress)addr).getHostName()).protocol;
                if (addrVersion != null) {
                    serverVer = addrVersion;
                }
                try {
                    ProtocolVersion autoVer;
                    if (serverVer == -2 && (autoVer = (ProtocolVersion)this.detectVersion((InetSocketAddress)addr).getNow(null)) != null) {
                        serverVer = autoVer.getVersion();
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning("Couldn't auto detect: " + e);
                }
            }
            boolean blocked = this.checkAddressBlocked(addr);
            boolean supported = ProtocolUtils.isSupported(serverVer, info.getProtocolVersion());
            this.handleMulticonnectPing(connection, info, blocked, serverVer);
            if (blocked || !supported) {
                serverVer = info.getProtocolVersion();
            }
            return serverVer;
        }
        NativeVersionProvider natProvider = (NativeVersionProvider)Via.getManager().getProviders().get(NativeVersionProvider.class);
        if (natProvider != null) {
            return ProtocolVersion.getProtocol((int)natProvider.getNativeServerVersion()).getVersion();
        }
        return super.getClosestServerProtocol(connection);
    }

    private boolean checkAddressBlocked(SocketAddress addr) {
        return addr instanceof InetSocketAddress && (this.isDisabled(((InetSocketAddress)addr).getHostString()) || ((InetSocketAddress)addr).getAddress() != null && (this.isDisabled(((InetSocketAddress)addr).getAddress().getHostAddress()) || this.isDisabled(((InetSocketAddress)addr).getAddress().getHostName())));
    }

    private void handleMulticonnectPing(UserConnection connection, ProtocolInfo info, boolean blocked, int serverVer) throws Exception {
        if (info.getState() == State.STATUS && info.getProtocolVersion() == -1 && this.isMulticonnectHandler(connection.getChannel().pipeline()) && (blocked || ProtocolUtils.isSupported(serverVer, this.getVersionForMulticonnect(serverVer)))) {
            int multiconnectSuggestion = blocked ? -1 : this.getVersionForMulticonnect(serverVer);
            this.getLogger().info("Sending " + ProtocolVersion.getProtocol((int)multiconnectSuggestion) + " for multiconnect version detector");
            PacketWrapper newAnswer = PacketWrapper.create((PacketType)ClientboundStatusPackets.STATUS_RESPONSE, null, (UserConnection)connection);
            newAnswer.write(Type.STRING, (Object)("{\"version\":{\"name\":\"viafabric integration\",\"protocol\":" + multiconnectSuggestion + "}}"));
            newAnswer.send(info.getPipeline().contains(BaseProtocol1_16.class) ? BaseProtocol1_16.class : BaseProtocol1_7.class);
            throw CancelException.generate();
        }
    }

    protected boolean isMulticonnectHandler(ChannelPipeline pipe) {
        return false;
    }

    private int getVersionForMulticonnect(int clientSideVersion) {
        int[] compatibleProtocols = this.multiconnectSupportedVersions;
        if (Arrays.binarySearch(compatibleProtocols, clientSideVersion) >= 0) {
            return clientSideVersion;
        }
        if (clientSideVersion < compatibleProtocols[0]) {
            return compatibleProtocols[0];
        }
        for (int i = compatibleProtocols.length - 1; i >= 0; --i) {
            int protocol = compatibleProtocols[i];
            if (clientSideVersion <= protocol || !ProtocolVersion.isRegistered((int)protocol)) continue;
            return protocol;
        }
        this.getLogger().severe("multiconnect integration: Panic, no protocol id found for " + clientSideVersion);
        return clientSideVersion;
    }

    private boolean isDisabled(String addr) {
        String[] parts = addr.split("\\.");
        boolean isNumericIp = parts.length == 4 && Arrays.stream(parts).map(Ints::tryParse).allMatch(Objects::nonNull);
        return IntStream.range(0, parts.length).anyMatch(i -> {
            String query = isNumericIp ? String.join((CharSequence)".", (CharSequence[])Arrays.stream(parts, 0, i + 1).toArray(String[]::new)) + (i != 3 ? ".*" : "") : (i != 0 ? "*." : "") + String.join((CharSequence)".", (CharSequence[])Arrays.stream(parts, i, parts.length).toArray(String[]::new));
            if (this.getConfig().isForcedDisable(query)) {
                this.getLogger().info(addr + " is force-disabled. (Matches " + query + ")");
                return true;
            }
            return false;
        });
    }

    protected abstract Logger getLogger();

    protected abstract VFConfig getConfig();

    protected abstract CompletableFuture<ProtocolVersion> detectVersion(InetSocketAddress var1);
}

