/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableSet;
import fi.dy.masa.malilib.MaLiLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_310;

public class FileUtils {
    private static final Set<Character> ILLEGAL_CHARACTERS = ImmutableSet.of((Object)Character.valueOf('/'), (Object)Character.valueOf('\n'), (Object)Character.valueOf('\r'), (Object)Character.valueOf('\t'), (Object)Character.valueOf('\u0000'), (Object)Character.valueOf('\f'), (Object[])new Character[]{Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});

    public static File getConfigDirectory() {
        return new File(class_310.method_1551().field_1697, "config");
    }

    public static File getMinecraftDirectory() {
        return class_310.method_1551().field_1697;
    }

    public static boolean canWriteToFile(File dir, String fileName, boolean canOverwrite) {
        if (dir.exists() && dir.isDirectory()) {
            File file = new File(dir, fileName);
            return !file.exists() || canOverwrite && file.isFile() && file.canWrite();
        }
        return false;
    }

    public static File getCanonicalFileIfPossible(File file) {
        try {
            File fileCan = file.getCanonicalFile();
            if (fileCan != null) {
                file = fileCan;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static String getJoinedTrailingPathElements(File file, File rootPath, int maxStringLength, String separator) {
        Object path = "";
        if (maxStringLength <= 0) {
            return "...";
        }
        while (file != null) {
            String name = file.getName();
            int len = ((String)(path = !((String)path).isEmpty() ? name + separator + (String)path : name)).length();
            if (len > maxStringLength) {
                path = "... " + ((String)path).substring(len - maxStringLength, len);
                break;
            }
            if (file.equals(rootPath)) break;
            file = file.getParentFile();
        }
        return path;
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(".");
        return i != -1 ? name.substring(0, i) : name;
    }

    public static String generateSimpleSafeFileName(String name) {
        return name.toLowerCase(Locale.US).replaceAll("\\W", "_");
    }

    public static String generateSafeFileName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (ILLEGAL_CHARACTERS.contains(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString().replaceAll("COM", "").replaceAll("PRN", "");
    }

    @Nullable
    public static class_2487 readNBTFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                FileInputStream is = new FileInputStream(file);
                class_2487 nbt = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
                is.close();
                return nbt;
            }
            catch (Exception e) {
                MaLiLib.logger.warn("Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return null;
    }
}

