/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.api.config.ConfigPackets;
import lol.bai.badpackets.api.config.ServerConfigPacketReceiver;
import lol.bai.badpackets.api.play.PlayPackets;
import lol.bai.badpackets.api.play.ServerPlayPacketReceiver;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.network.common.VersionPayload;
import mcp.mobius.waila.network.common.c2s.VersionCommonC2SPacket;
import mcp.mobius.waila.network.config.s2c.BlacklistSyncConfigS2CPacket;
import mcp.mobius.waila.network.config.s2c.ConfigSyncConfigS2CPacket;
import mcp.mobius.waila.network.config.s2c.VersionConfigS2CPacket;
import mcp.mobius.waila.network.play.c2s.BlockDataRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.EntityDataRequestPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.RawDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.c2s.TypedDataRequestContextPlayC2SPacket;
import mcp.mobius.waila.network.play.s2c.GenerateClientDumpPlayS2CPacket;
import mcp.mobius.waila.network.play.s2c.RawDataResponsePlayS2CPacket;
import mcp.mobius.waila.network.play.s2c.TypedDataResponsePlayS2CPacket;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class Packets {
    public static void initServer() {
        Packets.register(new VersionCommonC2SPacket());
        Packets.register(new BlockDataRequestPlayC2SPacket());
        Packets.register(new EntityDataRequestPlayC2SPacket());
        Packets.register(new RawDataRequestContextPlayC2SPacket());
        Packets.register(new TypedDataRequestContextPlayC2SPacket());
        ConfigPackets.registerServerReadyCallback((handler, sender, server) -> Packets.sendS2CHandshakePackets(sender));
        PlayPackets.registerServerReadyCallback((handler, sender, server) -> {
            if (sender.canSend(VersionPayload.ID)) {
                Packets.sendS2CHandshakePackets(sender);
            }
        });
    }

    public static void initClient() {
        Packets.register(new VersionConfigS2CPacket());
        Packets.register(new ConfigSyncConfigS2CPacket());
        Packets.register(new BlacklistSyncConfigS2CPacket());
        Packets.register(new GenerateClientDumpPlayS2CPacket());
        Packets.register(new RawDataResponsePlayS2CPacket());
        Packets.register(new TypedDataResponsePlayS2CPacket());
        ConfigPackets.registerClientReadyCallback((handler, sender, client) -> Packets.sendVersionPacket(sender));
    }

    private static void register(Packet<?> packet) {
        Packet play;
        Packet config;
        if (packet instanceof Packet.ConfigC2S) {
            config = (Packet.ConfigC2S)packet;
            ConfigPackets.registerServerReceiver((class_2960)config.id(), (class_2540.class_7461)config, (ServerConfigPacketReceiver)config);
        }
        if (packet instanceof Packet.ConfigS2C) {
            config = (Packet.ConfigS2C)packet;
            ConfigPackets.registerClientReceiver((class_2960)config.id(), config, config);
        }
        if (packet instanceof Packet.PlayC2S) {
            play = (Packet.PlayC2S)packet;
            PlayPackets.registerServerReceiver((class_2960)play.id(), (class_2540.class_7461)play, (ServerPlayPacketReceiver)play);
        }
        if (packet instanceof Packet.PlayS2C) {
            play = (Packet.PlayS2C)packet;
            PlayPackets.registerClientReceiver((class_2960)play.id(), play, play);
        }
    }

    private static void sendVersionPacket(PacketSender sender) {
        sender.send((class_8710)new VersionPayload(7));
    }

    private static void sendS2CHandshakePackets(PacketSender sender) {
        Packets.sendVersionPacket(sender);
        BlacklistConfig blacklistConfig = Waila.BLACKLIST_CONFIG.get();
        sender.send((class_8710)new BlacklistSyncConfigS2CPacket.Payload(blacklistConfig.blocks, blacklistConfig.blockEntityTypes, blacklistConfig.entityTypes));
        sender.send((class_8710)new ConfigSyncConfigS2CPacket.Payload(PluginConfig.getSyncableConfigs().stream().collect(Collectors.toMap(ConfigEntry::getId, ConfigEntry::getLocalValue))));
    }
}

