/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.api.IInstanceRegistry;

public class InstanceRegistry<T>
implements IInstanceRegistry<T> {
    private final Map<Class<?>, Set<EntryImpl<T>>> map = new Object2ObjectOpenHashMap();
    private final Map<Class<?>, List<IInstanceRegistry.Entry<T>>> cache = new Object2ObjectOpenHashMap();
    private boolean reversed = false;

    public void reversed() {
        this.reversed = true;
    }

    @Override
    public void add(Class<?> key, T instance, int priority) {
        this.map.computeIfAbsent(key, k -> new ObjectLinkedOpenHashSet()).add(new EntryImpl<T>(instance, priority));
    }

    @Override
    public List<IInstanceRegistry.Entry<T>> get(Object target) {
        if (target == null) {
            return ObjectLists.emptyList();
        }
        Class<?> clazz = target.getClass();
        if (clazz == Object.class) {
            return ObjectLists.emptyList();
        }
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        ObjectArrayList entries = new ObjectArrayList();
        this.map.forEach((arg_0, arg_1) -> InstanceRegistry.lambda$get$1(target, (List)entries, arg_0, arg_1));
        Comparator<IInstanceRegistry.Entry> comparator = Comparator.comparingInt(IInstanceRegistry.Entry::priority);
        if (this.reversed) {
            comparator = comparator.reversed();
        }
        entries.sort(comparator);
        ObjectList result = entries.isEmpty() ? ObjectLists.emptyList() : entries;
        this.cache.put(clazz, (List<IInstanceRegistry.Entry<T>>)result);
        return result;
    }

    public Map<Class<?>, Set<EntryImpl<T>>> getMap() {
        return this.map;
    }

    private static /* synthetic */ void lambda$get$1(Object target, List entries, Class k, Set v) {
        if (k.isInstance(target)) {
            entries.addAll(v);
        }
    }

    public record EntryImpl<T>(T instance, int priority) implements IInstanceRegistry.Entry<T>
    {
    }
}

