/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.impl.config;

import java.util.Objects;
import me.axieum.mcmod.authme.api.util.MicrosoftUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.jetbrains.annotations.Nullable;

@Config(name="authme")
public class AuthMeConfig
implements ConfigData {
    @Comment(value="Auth Button")
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public AuthButtonSchema authButton = new AuthButtonSchema();
    @Comment(value="Login Methods")
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public LoginMethodsSchema methods = new LoginMethodsSchema();

    public static ConfigHolder<AuthMeConfig> init() {
        ConfigHolder holder = AutoConfig.register(AuthMeConfig.class, JanksonConfigSerializer::new);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(AuthMeConfig.class).load());
        return holder;
    }

    public static class AuthButtonSchema {
        @Comment(value="Position of the button on the multiplayer screen")
        public int x = 6;
        @Comment(value="Position of the button on the multiplayer screen")
        public int y = 6;
        @Comment(value="True if the button can be dragged to a new position")
        public boolean draggable = true;
    }

    public static class LoginMethodsSchema {
        @Comment(value="Login via Microsoft")
        @ConfigEntry.Gui.CollapsibleObject
        public MicrosoftLoginSchema microsoft = new MicrosoftLoginSchema();
        @Comment(value="Login Offline")
        @ConfigEntry.Gui.CollapsibleObject
        public OfflineLoginSchema offline = new OfflineLoginSchema();

        public static class MicrosoftLoginSchema {
            @Comment(value="Indicates the type of user interaction that is required")
            public MicrosoftUtils.MicrosoftPrompt prompt = MicrosoftUtils.MicrosoftPrompt.DEFAULT;
            @Comment(value="The port from which to listen for OAuth2 callbacks")
            public int port = 25585;
            @Comment(value="OAuth2 client id")
            public String clientId = "e16699bb-2aa8-46da-b5e3-45cbcce29091";
            @Comment(value="OAuth2 authorization url")
            public String authorizeUrl = "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize";
            @Comment(value="OAuth2 access token url")
            public String tokenUrl = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";
            @Comment(value="Xbox authentication url")
            public String xboxAuthUrl = "https://user.auth.xboxlive.com/user/authenticate";
            @Comment(value="Xbox XSTS authorization url")
            public String xboxXstsUrl = "https://xsts.auth.xboxlive.com/xsts/authorize";
            @Comment(value="Minecraft authentication url")
            public String mcAuthUrl = "https://api.minecraftservices.com/authentication/login_with_xbox";
            @Comment(value="Minecraft profile url")
            public String mcProfileUrl = "https://api.minecraftservices.com/minecraft/profile";

            public boolean isDefaults() {
                return Objects.equals(this.authorizeUrl, "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize") && Objects.equals(this.tokenUrl, "https://login.microsoftonline.com/consumers/oauth2/v2.0/token") && Objects.equals(this.xboxAuthUrl, "https://user.auth.xboxlive.com/user/authenticate") && Objects.equals(this.xboxXstsUrl, "https://xsts.auth.xboxlive.com/xsts/authorize") && Objects.equals(this.mcAuthUrl, "https://api.minecraftservices.com/authentication/login_with_xbox") && Objects.equals(this.mcProfileUrl, "https://api.minecraftservices.com/minecraft/profile");
            }
        }

        public static class OfflineLoginSchema {
            @Comment(value="Last used username")
            @Nullable
            public String lastUsername = "";
        }
    }
}

