/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.RenderCulling;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.interop.TileEntitiesHelper;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.providers.BeaconProvider;
import com.irtimaled.bbor.client.providers.BedrockCeilingProvider;
import com.irtimaled.bbor.client.providers.BiomeBorderProvider;
import com.irtimaled.bbor.client.providers.ConduitProvider;
import com.irtimaled.bbor.client.providers.CustomBeaconProvider;
import com.irtimaled.bbor.client.providers.CustomBoxProvider;
import com.irtimaled.bbor.client.providers.CustomLineProvider;
import com.irtimaled.bbor.client.providers.CustomSphereProvider;
import com.irtimaled.bbor.client.providers.FlowerForestProvider;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.client.providers.MobSpawnerProvider;
import com.irtimaled.bbor.client.providers.SlimeChunkProvider;
import com.irtimaled.bbor.client.providers.SpawnableBlocksProvider;
import com.irtimaled.bbor.client.providers.SpawningSphereProvider;
import com.irtimaled.bbor.client.providers.WorldSpawnProvider;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.RenderQueue;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.DimensionId;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_4587;

public class ClientRenderer {
    private static final int CHUNK_SIZE = 16;
    private static final Map<Class<? extends AbstractBoundingBox>, AbstractRenderer> boundingBoxRendererMap = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private static boolean active;
    private static final Set<IBoundingBoxProvider> providers;
    private static AtomicLong lastDurationNanos;
    private static final ObjectArrayList<AbstractBoundingBox> listForRendering;

    public static boolean getActive() {
        return active;
    }

    public static void toggleActive() {
        boolean bl = active = !active;
        if (!active) {
            return;
        }
        Player.setActiveY();
    }

    static void deactivate() {
        active = false;
    }

    public static <T extends AbstractBoundingBox> void registerProvider(IBoundingBoxProvider<T> provider) {
        providers.add(provider);
    }

    public static <T extends AbstractBoundingBox> AbstractRenderer<T> registerRenderer(Class<? extends T> type, Supplier<AbstractRenderer<T>> renderer) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return null;
        }
        AbstractRenderer<T> renderer1 = renderer.get();
        boundingBoxRendererMap.put(type, renderer1);
        return renderer1;
    }

    public static AbstractRenderer getRenderer(Class<? extends AbstractBoundingBox> clazz) {
        return boundingBoxRendererMap.get(clazz);
    }

    private static boolean isWithinRenderDistance(AbstractBoundingBox boundingBox) {
        int renderDistanceBlocks = ClientInterop.getRenderDistanceChunks() * 16;
        int minX = MathHelper.floor(Player.getX() - (double)renderDistanceBlocks);
        int maxX = MathHelper.floor(Player.getX() + (double)renderDistanceBlocks);
        int minZ = MathHelper.floor(Player.getZ() - (double)renderDistanceBlocks);
        int maxZ = MathHelper.floor(Player.getZ() + (double)renderDistanceBlocks);
        return boundingBox.intersectsBounds(minX, minZ, maxX, maxZ);
    }

    public static void render(class_4587 matrixStack, DimensionId dimensionId) {
        if (!active) {
            return;
        }
        long startTime = System.nanoTime();
        matrixStack.method_22903();
        RenderHelper.beforeRender();
        TileEntitiesHelper.clearCache();
        List<AbstractBoundingBox> boundingBoxes = ClientRenderer.getBoundingBoxes(dimensionId);
        RenderCulling.flushPreRendering();
        for (AbstractBoundingBox key : boundingBoxes) {
            AbstractRenderer<?> renderer = key.getRenderer();
            if (renderer == null) continue;
            renderer.render(matrixStack, key);
        }
        RenderQueue.renderDeferred();
        RenderHelper.afterRender();
        RenderCulling.flushRendering();
        matrixStack.method_22909();
        lastDurationNanos.set(System.nanoTime() - startTime);
    }

    public static List<AbstractBoundingBox> getBoundingBoxes(DimensionId dimensionId) {
        listForRendering.clear();
        boolean doPreCulling = ConfigManager.fastRender.get() >= 2;
        for (IBoundingBoxProvider provider : providers) {
            if (!provider.canProvide(dimensionId)) continue;
            for (AbstractBoundingBox boundingBox2 : provider.get(dimensionId)) {
                if (!ClientRenderer.isWithinRenderDistance(boundingBox2) || doPreCulling && !boundingBox2.isVisibleCulling()) continue;
                listForRendering.add((Object)boundingBox2);
            }
        }
        Point point = Player.getPoint();
        listForRendering.sort(Comparator.comparingDouble(boundingBox -> boundingBox.getDistance(point.getX(), point.getY(), point.getZ())).reversed());
        return listForRendering;
    }

    public static void clear() {
        for (IBoundingBoxProvider provider : providers) {
            TypeHelper.doIfType(provider, ICachingProvider.class, ICachingProvider::clearCache);
        }
    }

    public static long getLastDurationNanos() {
        return lastDurationNanos.get();
    }

    static {
        providers = new HashSet<IBoundingBoxProvider>();
        lastDurationNanos = new AtomicLong(0L);
        ClientRenderer.registerProvider(new SlimeChunkProvider());
        ClientRenderer.registerProvider(new WorldSpawnProvider());
        ClientRenderer.registerProvider(new SpawningSphereProvider());
        ClientRenderer.registerProvider(new BeaconProvider());
        ClientRenderer.registerProvider(new CustomBoxProvider());
        ClientRenderer.registerProvider(new CustomBeaconProvider());
        ClientRenderer.registerProvider(new BiomeBorderProvider());
        ClientRenderer.registerProvider(new MobSpawnerProvider());
        ClientRenderer.registerProvider(new ConduitProvider());
        ClientRenderer.registerProvider(new SpawnableBlocksProvider());
        ClientRenderer.registerProvider(new CustomLineProvider());
        ClientRenderer.registerProvider(new CustomSphereProvider());
        ClientRenderer.registerProvider(new FlowerForestProvider());
        ClientRenderer.registerProvider(new BedrockCeilingProvider());
        listForRendering = new ObjectArrayList();
    }
}

