/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.ClientRenderer;
import com.irtimaled.bbor.client.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_238;
import net.minecraft.class_4604;

public class RenderCulling {
    private static volatile class_4604 frustum = null;
    private static final Object mutex = new Object();
    private static final AtomicInteger culledCount = new AtomicInteger();
    private static final AtomicInteger totalCount = new AtomicInteger();
    private static final AtomicInteger culledCountLast = new AtomicInteger();
    private static final AtomicInteger totalCountLast = new AtomicInteger();
    private static final AtomicInteger preCulledCountLast = new AtomicInteger();
    private static final AtomicInteger preTotalCountLast = new AtomicInteger();

    public static void setFrustum(class_4604 frustum) {
        RenderCulling.frustum = frustum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushRendering() {
        Object object = mutex;
        synchronized (object) {
            culledCountLast.set(culledCount.get());
            totalCountLast.set(totalCount.get());
            culledCount.set(0);
            totalCount.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushPreRendering() {
        Object object = mutex;
        synchronized (object) {
            preCulledCountLast.set(culledCount.get());
            preTotalCountLast.set(totalCount.get());
            culledCount.set(0);
            totalCount.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> debugStrings() {
        Object object;
        if (!ClientRenderer.getActive()) {
            return List.of("[BBOR] Rendering not enabled");
        }
        ArrayList<String> list = new ArrayList<String>(2);
        if (ConfigManager.fastRender.get() >= 2) {
            int preTotalCountLast;
            int preCulledCountLast;
            object = mutex;
            synchronized (object) {
                preCulledCountLast = RenderCulling.preCulledCountLast.get();
                preTotalCountLast = RenderCulling.preTotalCountLast.get();
            }
            list.add(String.format("[BBOR] Pre-culling: %d / %d (%.1f%%)", preCulledCountLast, preTotalCountLast, (double)((float)preCulledCountLast / (float)preTotalCountLast) * 100.0));
        }
        if (ConfigManager.fastRender.get() >= 1) {
            int totalCountLast;
            int culledCountLast;
            object = mutex;
            synchronized (object) {
                culledCountLast = RenderCulling.culledCountLast.get();
                totalCountLast = RenderCulling.totalCountLast.get();
            }
            list.add(String.format("[BBOR] Rendering culling: %d / %d (%.1f%%)", culledCountLast, totalCountLast, (double)((float)culledCountLast / (float)totalCountLast) * 100.0));
        }
        return list;
    }

    private static boolean cullFrustum(class_238 box) {
        class_4604 frustum = RenderCulling.frustum;
        if (frustum != null) {
            return frustum.method_23093(box);
        }
        return true;
    }

    public static boolean isVisibleCulling(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return RenderCulling.isVisibleCulling(new class_238(minX, minY, minZ, maxX, maxY, maxZ));
    }

    public static boolean isVisibleCulling(class_238 box) {
        boolean cullResult = RenderCulling.cullFrustum(box);
        totalCount.incrementAndGet();
        if (!cullResult) {
            culledCount.incrementAndGet();
        }
        return cullResult;
    }

    public static void incrementCulling() {
        totalCount.incrementAndGet();
    }
}

