/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

import com.irtimaled.bbor.client.config.ColorHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import com.irtimaled.bbor.common.BoundingBoxType;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Map;

public class BoundingBoxTypeHelper {
    private static final Map<String, BoundingBoxTypeSettings> structureTypeMap = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

    public static void registerType(BoundingBoxType type, Setting<Boolean> shouldRender, Setting<HexColor> color) {
        structureTypeMap.put(type.getName(), new BoundingBoxTypeSettings(shouldRender, color));
    }

    public static Setting<Boolean> renderSetting(BoundingBoxType type) {
        return BoundingBoxTypeHelper.structureTypeMap.get((Object)type.getName()).shouldRender;
    }

    public static boolean shouldRender(BoundingBoxType type) {
        BoundingBoxTypeSettings settings = structureTypeMap.get(type.getName());
        return settings != null ? settings.shouldRender.get() : false;
    }

    public static Color getColor(BoundingBoxType type) {
        BoundingBoxTypeSettings settings = structureTypeMap.get(type.getName());
        return settings != null ? ColorHelper.getColor(settings.color) : Color.WHITE;
    }

    static {
        BoundingBoxTypeHelper.registerType(BoundingBoxType.WorldSpawn, ConfigManager.drawWorldSpawn, ConfigManager.colorWorldSpawn);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SpawnChunks, ConfigManager.drawWorldSpawn, ConfigManager.colorWorldSpawn);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.LazySpawnChunks, ConfigManager.drawLazySpawnChunks, ConfigManager.colorLazySpawnChunks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.MobSpawner, ConfigManager.drawMobSpawners, ConfigManager.colorMobSpawners);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SlimeChunks, ConfigManager.drawSlimeChunks, ConfigManager.colorSlimeChunks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.AFKSphere, ConfigManager.drawAFKSpheres, ConfigManager.colorAFKSpheres);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BiomeBorder, ConfigManager.drawBiomeBorders, ConfigManager.colorBiomeBorders);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Beacon, ConfigManager.drawBeacons, ConfigManager.colorBeacons);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Custom, ConfigManager.drawConduits, ConfigManager.colorCustom);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Conduit, ConfigManager.drawConduits, ConfigManager.colorConduits);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SpawnableBlocks, ConfigManager.drawSpawnableBlocks, ConfigManager.colorSpawnableBlocks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.FlowerForest, ConfigManager.drawFlowerForests, null);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BedrockCeiling, ConfigManager.drawBedrockCeilingBlocks, ConfigManager.colorBedrockCeilingBlocks);
    }

    private static class BoundingBoxTypeSettings {
        private final Setting<Boolean> shouldRender;
        private final Setting<HexColor> color;

        public BoundingBoxTypeSettings(Setting<Boolean> shouldRender, Setting<HexColor> color) {
            this.shouldRender = shouldRender;
            this.color = color;
        }
    }
}

