/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ColorHelper {
    private static final Map<HexColor, Color> colorMap = new HashMap<HexColor, Color>();

    private static Color getColor(HexColor value) {
        return colorMap.computeIfAbsent(value, ColorHelper::decodeColor);
    }

    private static Color decodeColor(HexColor hexColor) {
        try {
            int color = Integer.decode(hexColor.getValue());
            return new Color(color, hexColor.hasAlpha());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Color getColor(Setting<HexColor> value) {
        if (value == null) {
            return Color.WHITE;
        }
        Color color = ColorHelper.getColor(value.get());
        return color != null ? color : ColorHelper.getColor((HexColor)value.defaultValue);
    }
}

