/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

import com.irtimaled.bbor.client.config.Configuration;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ConfigManager {
    private static final Set<Setting<?>> settings = new HashSet();
    private static File configDir;
    public static Setting<Boolean> fill;
    public static Setting<Boolean> alwaysVisible;
    public static Setting<Boolean> drawSlimeChunks;
    public static Setting<Integer> slimeChunkMaxY;
    public static Setting<Boolean> keepCacheBetweenSessions;
    public static Setting<Boolean> drawWorldSpawn;
    public static Setting<Integer> worldSpawnMaxY;
    public static Setting<Boolean> drawLazySpawnChunks;
    public static Setting<Boolean> drawMobSpawners;
    public static Setting<Boolean> renderMobSpawnerSpawnArea;
    public static Setting<Boolean> renderMobSpawnerActivationLines;
    public static Setting<Boolean> outerBoxesOnly;
    public static Setting<Boolean> drawAFKSpheres;
    public static Setting<Boolean> renderAFKSpawnableBlocks;
    public static Setting<Integer> afkSpawnableBlocksRenderDistance;
    public static Setting<Boolean> drawBeacons;
    public static Setting<Boolean> drawBiomeBorders;
    public static Setting<Boolean> renderOnlyCurrentBiome;
    public static Setting<Integer> biomeBordersRenderDistance;
    public static Setting<Integer> biomeBordersMaxY;
    public static Setting<Boolean> drawConduits;
    public static Setting<Boolean> renderConduitMobHarmArea;
    public static Setting<Boolean> drawSpawnableBlocks;
    public static Setting<Integer> spawnableBlocksRenderWidth;
    public static Setting<Integer> spawnableBlocksRenderHeight;
    public static Setting<Boolean> invertBoxColorPlayerInside;
    public static Setting<Boolean> renderSphereAsDots;
    public static Setting<Boolean> drawFlowerForests;
    public static Setting<Integer> flowerForestsRenderDistance;
    public static Setting<Boolean> drawBedrockCeilingBlocks;
    public static Setting<HexColor> colorWorldSpawn;
    public static Setting<HexColor> colorLazySpawnChunks;
    public static Setting<HexColor> colorMobSpawners;
    public static Setting<HexColor> colorMobSpawnersLineFarAway;
    public static Setting<HexColor> colorMobSpawnersLineNearby;
    public static Setting<HexColor> colorMobSpawnersLineActive;
    public static Setting<HexColor> colorSlimeChunks;
    public static Setting<HexColor> colorAFKSpheres;
    public static Setting<HexColor> colorAFKSpheresSafeArea;
    public static Setting<HexColor> colorBiomeBorders;
    public static Setting<HexColor> colorBeacons;
    public static Setting<HexColor> colorCustom;
    public static Setting<HexColor> colorConduits;
    public static Setting<HexColor> colorConduitMobHarmArea;
    public static Setting<HexColor> colorSpawnableBlocks;
    public static Setting<HexColor> colorFlowerForestDandelion;
    public static Setting<HexColor> colorFlowerForestPoppy;
    public static Setting<HexColor> colorFlowerForestAllium;
    public static Setting<HexColor> colorFlowerForestAzureBluet;
    public static Setting<HexColor> colorFlowerForestRedTulip;
    public static Setting<HexColor> colorFlowerForestOrangeTulip;
    public static Setting<HexColor> colorFlowerForestWhiteTulip;
    public static Setting<HexColor> colorFlowerForestPinkTulip;
    public static Setting<HexColor> colorFlowerForestOxeyeDaisy;
    public static Setting<HexColor> colorFlowerForestCornflower;
    public static Setting<HexColor> colorFlowerForestLilyOfTheValley;
    public static Setting<HexColor> colorBedrockCeilingBlocks;
    public static Setting<HexColor> buttonOnOverlay;
    public static Setting<Integer> fastRender;
    public static Map<String, Setting<Boolean>> structureRenderSettings;
    public static Map<String, Setting<HexColor>> structureColorSettings;
    private static final Map<String, HexColor> defaultStructureColors;
    private static Configuration config;

    public static void loadConfig() {
        configDir = new File(".", "config");
        configDir.mkdirs();
        config = ConfigManager.loadConfiguration();
        fill = ConfigManager.setup(config, "general", "fill", true, "If set to true the bounding boxes are filled.");
        outerBoxesOnly = ConfigManager.setup(config, "general", "outerBoxesOnly", false, "If set to true only the outer bounding boxes are rendered.");
        alwaysVisible = ConfigManager.setup(config, "general", "alwaysVisible", false, "If set to true boxes will be visible even through other blocks.");
        keepCacheBetweenSessions = ConfigManager.setup(config, "general", "keepCacheBetweenSessions", false, "If set to true bounding box caches will be kept between sessions.");
        invertBoxColorPlayerInside = ConfigManager.setup(config, "general", "invertBoxColorPlayerInside", false, "If set to true the color of any bounding box the player is inside will be inverted.");
        renderSphereAsDots = ConfigManager.setup(config, "general", "renderSphereAsDots", false, "If set to true spheres will be rendered as dots.");
        buttonOnOverlay = ConfigManager.setup(config, "general", "buttonEnabledOverlay", HexColor.from("#3000ff00"), "The color and alpha of the button overlay when a button is on.");
        fastRender = ConfigManager.setup(config, "general", "fastRender", 2, "Fast render settings. Higher value for faster rendering. ");
        drawBeacons = ConfigManager.setup(config, "beacons", "drawBeacons", true, "If set to true beacon bounding boxes will be drawn.");
        drawConduits = ConfigManager.setup(config, "conduits", "drawConduits", true, "If set to true conduit bounding spheres will be drawn.");
        renderConduitMobHarmArea = ConfigManager.setup(config, "conduits", "renderConduitMobHarmArea", true, "If set to true a box to show the area where hostile mobs are harmed will be drawn");
        drawBiomeBorders = ConfigManager.setup(config, "biomeBorders", "drawBiomeBorders", true, "If set to true biome borders will be drawn.");
        renderOnlyCurrentBiome = ConfigManager.setup(config, "biomeBorders", "renderOnlyCurrentBiome", true, "If set to true only the biome border for the current biome will be drawn.");
        biomeBordersRenderDistance = ConfigManager.setup(config, "biomeBorders", "biomeBordersRenderDistance", 3, "The distance from the player where biome borders will be drawn.");
        biomeBordersMaxY = ConfigManager.setup(config, "biomeBorders", "biomeBordersMaxY", -1, "The maximum top of the biome borders. If set to -1 it will use the value when activated, if set to 0 it will always track the players feet.");
        drawFlowerForests = ConfigManager.setup(config, "flowerForests", "drawFlowerForests", true, "If set to true flower forest flower overlays will be drawn.");
        flowerForestsRenderDistance = ConfigManager.setup(config, "flowerForests", "flowerForestsRenderDistance", 3, "The distance from the player where flower forests will be drawn.");
        drawBedrockCeilingBlocks = ConfigManager.setup(config, "bedrockCeiling", "drawBedrockCeilingBlocks", true, "If set to true position with only one layer of bedrock will be drawn.");
        drawSlimeChunks = ConfigManager.setup(config, "slimeChunks", "drawSlimeChunks", true, "If set to true slime chunks bounding boxes are drawn.");
        slimeChunkMaxY = ConfigManager.setup(config, "slimeChunks", "slimeChunkMaxY", -1, "The maximum top of the slime chunk bounding box. If set to -1 it will use the value when activated, if set to 0 it will always track the player's feet.");
        drawWorldSpawn = ConfigManager.setup(config, "worldSpawn", "drawWorldSpawn", true, "If set to true world spawn and spawn chunks bounding boxes are drawn.");
        worldSpawnMaxY = ConfigManager.setup(config, "worldSpawn", "worldSpawnMaxY", -1, "The maximum top of the world spawn bounding boxes. If set to -1 it will use the value when activated, if set to 0 it will always track the players feet.");
        drawLazySpawnChunks = ConfigManager.setup(config, "worldSpawn", "drawLazySpawnChunks", false, "If set to true the lazy spawn chunks bounding boxes will be drawn.");
        drawMobSpawners = ConfigManager.setup(config, "mobSpawners", "drawMobSpawners", true, "If set to true mob spawners will be drawn.");
        renderMobSpawnerSpawnArea = ConfigManager.setup(config, "mobSpawners", "renderMobSpawnerSpawnArea", true, "If set to true a box to show the maximum possible spawn area (10x10x4) for a spawner will be drawn");
        renderMobSpawnerActivationLines = ConfigManager.setup(config, "mobSpawners", "renderMobSpawnerActivationLines", true, "If set to true a red/orange/green line will be drawn to show if the spawner is active");
        drawAFKSpheres = ConfigManager.setup(config, "afkSpot", "drawAFKSpheres", true, "If set to true afk spot spheres will be drawn.");
        renderAFKSpawnableBlocks = ConfigManager.setup(config, "afkSpot", "renderAFKSpawnableBlocks", true, "If set to true boxes to show spawnable blocks within the AFK sphere will be drawn.");
        afkSpawnableBlocksRenderDistance = ConfigManager.setup(config, "afkSpot", "afkSpawnableBlocksRenderDistance", 3, "The distance from the player where spawnable blocks within the AFK sphere will be drawn.");
        drawSpawnableBlocks = ConfigManager.setup(config, "spawnableBlocks", "drawSpawnableBlocks", false, "If set to true boxes to show spawnable blocks will be drawn.");
        spawnableBlocksRenderWidth = ConfigManager.setup(config, "spawnableBlocks", "spawnableBlocksRenderWidth", 2, "The distance from the player where spawnable blocks will be drawn in X and Z axis.");
        spawnableBlocksRenderHeight = ConfigManager.setup(config, "spawnableBlocks", "spawnableBlocksRenderHeight", 1, "The distance from the player where spawnable blocks will be drawn in Y axis.");
        colorWorldSpawn = ConfigManager.setup(config, "colors", "colorWorldSpawn", HexColor.from("#ff0000"), "Color of world spawn and spawn chunks bounding boxes.");
        colorLazySpawnChunks = ConfigManager.setup(config, "colors", "colorLazySpawnChunks", HexColor.from("#ff0000"), "Color of lazy spawn chunks bounding boxes.");
        colorMobSpawners = ConfigManager.setup(config, "colors", "colorMobSpawners", HexColor.from("#00ff00"), "Color of mob spawners.");
        colorMobSpawnersLineFarAway = ConfigManager.setup(config, "colors", "colorMobSpawnersLineFarAway", HexColor.from("#ff0000"), "Color of mob spawner activation line if spawner far away.");
        colorMobSpawnersLineNearby = ConfigManager.setup(config, "colors", "colorMobSpawnersLineNearby", HexColor.from("#ff7f00"), "Color of mob spawners activation line if spawner nearby.");
        colorMobSpawnersLineActive = ConfigManager.setup(config, "colors", "colorMobSpawnersLineActive", HexColor.from("#00ff00"), "Color of mob spawners activation line if spawner active.");
        colorSlimeChunks = ConfigManager.setup(config, "colors", "colorSlimeChunks", HexColor.from("#006000"), "Color of slime chunks bounding boxes.");
        colorAFKSpheres = ConfigManager.setup(config, "colors", "colorAFKSpheres", HexColor.from("#ff0000"), "Color of afk spot spheres.");
        colorAFKSpheresSafeArea = ConfigManager.setup(config, "colors", "colorAFKSpheresSafeArea", HexColor.from("#00ff00"), "Color of afk spot safe area spheres.");
        colorBiomeBorders = ConfigManager.setup(config, "colors", "colorBiomeBorders", HexColor.from("#00ff00"), "Color of biome borders.");
        colorBeacons = ConfigManager.setup(config, "colors", "colorBeacons", HexColor.from("#ffffff"), "Color of beacon bounding boxes.");
        colorCustom = ConfigManager.setup(config, "colors", "colorCustom", HexColor.from("#ffffff"), "Color of all types of custom boxes.");
        colorConduits = ConfigManager.setup(config, "colors", "colorConduits", HexColor.from("#00ffff"), "Color of conduit bounding spheres.");
        colorConduitMobHarmArea = ConfigManager.setup(config, "colors", "colorConduitMobHarmArea", HexColor.from("#ff7f00"), "Color of conduit mob harm bounding boxes.");
        colorSpawnableBlocks = ConfigManager.setup(config, "colors", "colorSpawnableBlocks", HexColor.from("#ff0000"), "Color of spawnable blocks.");
        colorFlowerForestDandelion = ConfigManager.setup(config, "colors", "colorFlowerForestDandelion", HexColor.from("#ffff00"), "Color of Flower Forest Dandelion");
        colorFlowerForestPoppy = ConfigManager.setup(config, "colors", "colorFlowerForestPoppy", HexColor.from("#ff0000"), "Color of Flower Forest Poppy");
        colorFlowerForestAllium = ConfigManager.setup(config, "colors", "colorFlowerForestAllium", HexColor.from("#ff00ff"), "Color of Flower Forest Allium");
        colorFlowerForestAzureBluet = ConfigManager.setup(config, "colors", "colorFlowerForestAzureBluet", HexColor.from("#d3d3d3"), "Color of Flower Forest Azure Bluet");
        colorFlowerForestRedTulip = ConfigManager.setup(config, "colors", "colorFlowerForestRedTulip", HexColor.from("#ff0000"), "Color of Flower Forest Red Tulip");
        colorFlowerForestOrangeTulip = ConfigManager.setup(config, "colors", "colorFlowerForestOrangeTulip", HexColor.from("#ff681f"), "Color of Flower Forest Orange Tulip");
        colorFlowerForestWhiteTulip = ConfigManager.setup(config, "colors", "colorFlowerForestWhiteTulip", HexColor.from("#d3d3d3"), "Color of Flower Forest White Tulip");
        colorFlowerForestPinkTulip = ConfigManager.setup(config, "colors", "colorFlowerForestPinkTulip", HexColor.from("#ff69b4"), "Color of Flower Forest Pink Tulip");
        colorFlowerForestOxeyeDaisy = ConfigManager.setup(config, "colors", "colorFlowerForestOxeyeDaisy", HexColor.from("#d3d3d3"), "Color of Flower Forest Oxeye Daisy");
        colorFlowerForestCornflower = ConfigManager.setup(config, "colors", "colorFlowerForestCornflower", HexColor.from("#0000ff"), "Color of Flower Forest Cornflower");
        colorFlowerForestLilyOfTheValley = ConfigManager.setup(config, "colors", "colorFlowerForestLilyOfTheValley", HexColor.from("#ffffff"), "Color of Flower Forest Lily Of The Valley");
        colorBedrockCeilingBlocks = ConfigManager.setup(config, "colors", "colorBedrockCeilingBlocks", HexColor.from("#00ff00"), "Color of Bedrock Ceiling Blocks");
        config.save();
    }

    private static Configuration loadConfiguration() {
        Configuration config = new Configuration(new File(configDir, "BBOutlineReloaded.cfg"));
        config.load();
        return config;
    }

    public static void saveConfig() {
        Configuration config = new Configuration(new File(configDir, "BBOutlineReloaded.cfg"));
        for (Setting<?> setting : settings) {
            config.put(setting);
        }
        config.save();
    }

    public static Setting<Boolean> structureShouldRender(String key) {
        Setting<Boolean> setting = structureRenderSettings.put(key, ConfigManager.setup(config, "structures", "drawStructure_" + key.replace(':', '_'), true, "If set to true structure %s bounding boxes will be drawn.".formatted(key)));
        ConfigManager.saveConfig();
        return setting;
    }

    public static Setting<HexColor> structureColor(String key) {
        Setting<HexColor> setting = structureColorSettings.put(key, ConfigManager.setup(config, "colors", "colorStructure_" + key.replace(':', '_'), defaultStructureColors.getOrDefault(key, HexColor.from("#ffffff")), "Color if structure %s bounding boxes.".formatted(key)));
        ConfigManager.saveConfig();
        return setting;
    }

    private static <T> Setting<T> setup(Configuration config, String category, String settingName, T defaultValue, String comment) {
        Setting<T> setting = config.get(category, settingName, defaultValue);
        setting.category = category;
        setting.name = settingName;
        setting.defaultValue = defaultValue;
        if (setting.get() == null) {
            setting.reset();
        }
        setting.comment = comment + " (default: " + defaultValue.toString() + ")";
        settings.add(setting);
        return setting;
    }

    public static void Toggle(Setting<Boolean> setting) {
        setting.set(setting.get() == false);
    }

    public static Set<Setting<?>> getSettings() {
        return settings;
    }

    static {
        structureRenderSettings = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        structureColorSettings = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        defaultStructureColors = new Object2ObjectOpenHashMap();
        defaultStructureColors.put("minecraft:fortress", Objects.requireNonNull(HexColor.from("#ff0000")));
        defaultStructureColors.put("minecraft:village_desert", Objects.requireNonNull(HexColor.from("#800080")));
        defaultStructureColors.put("minecraft:village_snowy", Objects.requireNonNull(HexColor.from("#800080")));
        defaultStructureColors.put("minecraft:village_plains", Objects.requireNonNull(HexColor.from("#800080")));
        defaultStructureColors.put("minecraft:village_savanna", Objects.requireNonNull(HexColor.from("#800080")));
        defaultStructureColors.put("minecraft:village_taiga", Objects.requireNonNull(HexColor.from("#800080")));
        defaultStructureColors.put("minecraft:desert_pyramid", Objects.requireNonNull(HexColor.from("#ffc800")));
        defaultStructureColors.put("minecraft:swamp_hut", Objects.requireNonNull(HexColor.from("#0000ff")));
        defaultStructureColors.put("minecraft:monument", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:shipwreck", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:shipwreck_beached", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:ocean_ruin_cold", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:ocean_ruin_warm", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:buried_treasure", Objects.requireNonNull(HexColor.from("#00ffff")));
        defaultStructureColors.put("minecraft:stronghold", Objects.requireNonNull(HexColor.from("#ffff00")));
        defaultStructureColors.put("minecraft:mineshaft", Objects.requireNonNull(HexColor.from("#c0c0c0")));
        defaultStructureColors.put("minecraft:end_city", Objects.requireNonNull(HexColor.from("#ff00ff")));
        defaultStructureColors.put("minecraft:mansion", Objects.requireNonNull(HexColor.from("#8b4513")));
        defaultStructureColors.put("minecraft:igloo", Objects.requireNonNull(HexColor.from("#ffffff")));
        defaultStructureColors.put("minecraft:pillager_outpost", Objects.requireNonNull(HexColor.from("#404040")));
        defaultStructureColors.put("minecraft:nether_fossil", Objects.requireNonNull(HexColor.from("#ffffff")));
        defaultStructureColors.put("minecraft:bastion_remnant", Objects.requireNonNull(HexColor.from("#c0c0c0")));
        defaultStructureColors.put("minecraft:ruined_portal", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_desert", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_mountain", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_jungle", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_ocean", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_swamp", Objects.requireNonNull(HexColor.from("#c800ff")));
        defaultStructureColors.put("minecraft:ruined_portal_nether", Objects.requireNonNull(HexColor.from("#c800ff")));
    }
}

