/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

import com.google.common.io.Files;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Configuration {
    private static final String FALLBACK_CATEGORY = "features";
    private final File file;
    private final Map<String, Map<String, Setting<?>>> settingsGroup = new HashMap();

    Configuration(File file) {
        this.file = file;
    }

    void save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));){
            writer.write("# Configuration file\n");
            for (String category : this.settingsGroup.keySet()) {
                writer.write("\n");
                writer.write(String.format("%s {\n", category));
                Map<String, Setting<?>> settings = this.settingsGroup.get(category);
                boolean first = true;
                for (String settingName : settings.keySet()) {
                    if (!first) {
                        writer.write("\n");
                    }
                    first = false;
                    Setting<?> setting = settings.get(settingName);
                    writer.write(String.format("    # %s\n", setting.comment));
                    writer.write(String.format("    %s:%s=%s\n", Character.valueOf(setting.getType()), settingName, setting.get()));
                }
                writer.write("}\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void load() {
        try {
            List lines = Files.readLines((File)this.file, (Charset)StandardCharsets.UTF_8);
            String category = null;
            String lastCommentLine = null;
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty()) continue;
                if (trimmedLine.startsWith("#")) {
                    lastCommentLine = trimmedLine.substring(1).trim();
                    continue;
                }
                if (trimmedLine.equals("}")) {
                    category = null;
                    continue;
                }
                if (category == null && trimmedLine.endsWith("{")) {
                    category = trimmedLine.substring(0, trimmedLine.length() - 1).trim();
                    this.settingsGroup.put(category, new HashMap());
                    continue;
                }
                if (category == null) continue;
                String[] items = trimmedLine.split("[:=]");
                char type = items[0].charAt(0);
                String name = items[1];
                String stringValue = items[2];
                Setting<?> setting = this.getTypedSetting(type, stringValue);
                setting.comment = lastCommentLine;
                this.settingsGroup.get(category).put(name, setting);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Setting<?> getTypedSetting(char type, String value) {
        switch (type) {
            case 'I': {
                return new Setting<Integer>(type, Integer.parseInt(value));
            }
            case 'B': {
                return new Setting<Boolean>(type, value.equals("1") || value.toLowerCase().equals("true"));
            }
            case 'H': {
                return new Setting<HexColor>(type, HexColor.from(value));
            }
        }
        return new Setting<String>(type, value);
    }

    <T> Setting<T> get(String category, String settingName, T defaultValue) {
        Map<String, Setting<?>> settings;
        Setting<Object> setting;
        char type = this.getType(defaultValue);
        if (!this.settingsGroup.containsKey(category)) {
            this.settingsGroup.put(category, new HashMap());
        }
        if ((setting = (settings = this.settingsGroup.get(category)).get(settingName)) == null && !category.equals(FALLBACK_CATEGORY)) {
            setting = this.getFallbackSetting(settingName, settings);
        }
        if (setting != null && setting.getType() != type) {
            setting = null;
        }
        if (setting == null) {
            setting = new Setting<T>(type, defaultValue);
            settings.put(settingName, setting);
        }
        return setting;
    }

    private Setting<?> getFallbackSetting(String settingName, Map<String, Setting<?>> settings) {
        Map<String, Setting<?>> fallbackSettings = this.settingsGroup.get(FALLBACK_CATEGORY);
        if (fallbackSettings == null) {
            return null;
        }
        Setting<?> setting = fallbackSettings.get(settingName);
        if (setting != null) {
            fallbackSettings.remove(settingName);
            settings.put(settingName, setting);
        }
        return setting;
    }

    private <T> char getType(T defaultValue) {
        String[] typeNames = defaultValue.getClass().getName().split("[.]");
        return typeNames[typeNames.length - 1].charAt(0);
    }

    void put(Setting<?> setting) {
        String category = setting.category;
        if (!this.settingsGroup.containsKey(category)) {
            this.settingsGroup.put(category, new HashMap());
        }
        Map<String, Setting<?>> settings = this.settingsGroup.get(category);
        settings.put(setting.name, setting);
    }
}

