/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.gui;

import com.irtimaled.bbor.client.gui.ControlListEntry;
import com.irtimaled.bbor.client.gui.ControlListSection;
import com.irtimaled.bbor.client.gui.CreateControl;
import com.irtimaled.bbor.client.gui.IControl;
import com.irtimaled.bbor.client.gui.IControlSet;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.Renderer;
import com.irtimaled.bbor.common.MathHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class ControlList
extends class_332
implements IControlSet {
    public static final int CONTROLS_WIDTH = 310;
    protected static final int PADDING = 8;
    protected final int listLeft;
    protected final List<ControlListEntry> entries = new ArrayList<ControlListEntry>();
    private final int scrollBarLeft;
    private final int listHeight;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    protected int contentHeight = 8;
    private double amountScrolled;
    private boolean clickedScrollbar;
    private boolean transparentBackground;
    private IControl focused;
    private boolean isDragging;

    ControlList(int width, int height, int top, int bottom) {
        this.width = width;
        this.scrollBarLeft = width - 6;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.listHeight = bottom - top;
        this.listLeft = width / 2 - 155;
    }

    void add(ControlListEntry entry) {
        entry.index = this.entries.size();
        this.addEntry(entry);
    }

    private void addEntry(ControlListEntry entry) {
        this.entries.add(entry);
        this.contentHeight += entry.getControlHeight();
    }

    public void filter(String lowerValue) {
        int height = 0;
        for (ControlListEntry entry : this.entries) {
            entry.filter(lowerValue);
            if (entry.method_1885()) {
                height += entry.getControlHeight();
                continue;
            }
            if (entry != this.focused) continue;
            this.focused = null;
        }
        this.contentHeight = height + 8;
    }

    void close() {
        this.entries.forEach(ControlListEntry::close);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = button == 0 && mouseX >= (double)this.scrollBarLeft;
        return this.method_25405(mouseX, mouseY) && (IControlSet.super.method_25402(mouseX, mouseY, button) || this.clickedScrollbar);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    @Override
    public boolean method_25407(boolean moveForward) {
        boolean newControlFocused = IControlSet.super.method_25407(moveForward);
        if (newControlFocused) {
            this.ensureVisible((ControlListEntry)this.getFocused());
        }
        return newControlFocused;
    }

    private void ensureVisible(ControlListEntry control) {
        int controlTop = control.getControlTop();
        int controlHeight = control.getControlHeight();
        int distanceAboveTop = this.top - controlTop;
        if (distanceAboveTop > 0) {
            this.amountScrolled -= (double)Math.max(controlHeight, distanceAboveTop + 8);
            return;
        }
        int distanceBelowBottom = controlTop + controlHeight - this.bottom;
        if (distanceBelowBottom > 0) {
            this.amountScrolled += (double)Math.max(controlHeight, distanceBelowBottom + 8);
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (IControlSet.super.method_25403(mouseX, mouseY, button, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (button == 0 && this.clickedScrollbar) {
            if (mouseY < (double)this.top) {
                this.amountScrolled = 0.0;
            } else if (mouseY > (double)this.bottom) {
                this.amountScrolled = this.getMaxScroll();
            } else {
                double amountScrolled;
                double maxScroll = this.getMaxScroll();
                if (maxScroll < 1.0) {
                    maxScroll = 1.0;
                }
                if ((amountScrolled = maxScroll / (double)(this.listHeight - this.getScrollBarHeight())) < 1.0) {
                    amountScrolled = 1.0;
                }
                this.amountScrolled += p_mouseDragged_8_ * amountScrolled;
            }
            return true;
        }
        return false;
    }

    private int getMaxScroll() {
        return Math.max(0, this.contentHeight - (this.listHeight - 4));
    }

    private int getScrollBarHeight() {
        return MathHelper.clamp((int)((float)(this.listHeight * this.listHeight) / (float)this.contentHeight), 32, this.listHeight - 8);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollAmount) {
        this.amountScrolled -= scrollAmount * 10.0;
        return true;
    }

    public void render(class_4587 matrixStack, int mouseX, int mouseY) {
        this.amountScrolled = MathHelper.clamp(this.amountScrolled, 0.0, (double)this.getMaxScroll());
        int listTop = this.top + 8 - (int)this.amountScrolled;
        this.drawEntries(matrixStack, mouseX, mouseY, listTop);
        RenderHelper.enableDepthTest();
        RenderHelper.depthFuncAlways();
        this.overlayBackground(0, this.top);
        this.overlayBackground(this.bottom, this.height);
        RenderHelper.depthFuncLessEqual();
        RenderHelper.disableDepthTest();
        RenderHelper.enableBlend();
        RenderHelper.blendFuncGui();
        RenderHelper.disableTexture();
        this.drawOverlayShadows();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            this.drawScrollBar(maxScroll);
        }
        RenderHelper.enableTexture();
        RenderHelper.disableBlend();
    }

    private void drawListBackground(class_4587 matrixStack) {
        class_310.method_1551().method_1531().method_22813(class_332.field_22735);
        Renderer.startTextured().setMatrixStack(matrixStack).setColor(32, 32, 32).setAlpha(255).addPoint(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.amountScrolled) / 32.0f).addPoint(this.width, this.bottom, 0.0, (float)this.width / 32.0f, (float)(this.bottom + (int)this.amountScrolled) / 32.0f).addPoint(this.width, this.top, 0.0, (float)this.width / 32.0f, (float)(this.top + (int)this.amountScrolled) / 32.0f).addPoint(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.amountScrolled) / 32.0f).render();
    }

    private void drawEntries(class_4587 matrixStack, int mouseX, int mouseY, int top) {
        for (ControlListEntry entry : this.entries) {
            if (!entry.method_1885()) continue;
            entry.setX(this.listLeft);
            entry.setY(top);
            int height = entry.getControlHeight();
            int bottom = top + height;
            if (top <= this.bottom && bottom >= this.top) {
                this.drawEntry(matrixStack, mouseX, mouseY, top, entry, height);
            }
            top = bottom;
        }
    }

    protected void drawEntry(class_4587 matrixStack, int mouseX, int mouseY, int top, ControlListEntry entry, int height) {
        entry.render(matrixStack, mouseX, mouseY);
    }

    private void overlayBackground(int top, int bottom) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22735);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912(0.0, (double)bottom, -100.0).method_22913(0.0f, (float)bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)bottom, -100.0).method_22913((float)this.width / 32.0f, (float)bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)top, -100.0).method_22913((float)this.width / 32.0f, (float)top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912(0.0, (double)top, -100.0).method_22913(0.0f, (float)top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        tessellator.method_1350();
    }

    private void drawScrollBar(int maxScroll) {
        int scrollBarHeight = this.getScrollBarHeight();
        int scrollBarTop = (int)this.amountScrolled * (this.listHeight - scrollBarHeight) / maxScroll + this.top;
        if (scrollBarTop < this.top) {
            scrollBarTop = this.top;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)(scrollBarTop + scrollBarHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)(scrollBarTop + scrollBarHeight), 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)scrollBarTop, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)scrollBarTop, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)(scrollBarTop + scrollBarHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(this.width - 1), (double)(scrollBarTop + scrollBarHeight - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(this.width - 1), (double)scrollBarTop, 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)this.scrollBarLeft, (double)scrollBarTop, 0.0).method_1336(192, 192, 192, 255).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
    }

    private void drawOverlayShadows() {
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912(0.0, (double)(this.top + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)(this.top + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912(0.0, (double)this.top, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)(this.bottom - 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912(0.0, (double)(this.bottom - 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912(0.0, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.width, (double)this.bottom, 0.0).method_1336(0, 0, 0, 255).method_1344();
        tessellator.method_1350();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    ControlList section(String title, CreateControl ... createControls) {
        this.add(new ControlListSection(title, -1, createControls));
        return this;
    }

    ControlList section(String title, int columnCount, CreateControl ... createControls) {
        this.add(new ControlListSection(title, columnCount, createControls));
        return this;
    }

    void setTransparentBackground() {
        this.transparentBackground = true;
    }

    @Override
    public List<? extends IControl> controls() {
        return this.entries;
    }

    @Override
    public IControl getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(IControl control) {
        this.focused = control;
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }
}

