/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.gui;

import com.google.common.hash.Hashing;
import com.irtimaled.bbor.client.gui.ControlListEntry;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_4587;
import net.minecraft.class_5218;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSaveRow
extends ControlListEntry
implements Comparable<WorldSaveRow> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final class_2960 ICON_MISSING = new class_2960("textures/misc/unknown_server.png");
    private static final int ICON_SIZE = 20;
    private final class_310 client;
    private final class_34 worldSummary;
    private final class_32 saveLoader;
    private final Consumer<ControlListEntry> setSelectedEntry;
    private final class_2960 iconLocation;
    private final class_1043 icon;
    private File iconFile;
    private long lastClickTime;

    WorldSaveRow(class_34 worldSummary, class_32 saveLoader, Consumer<ControlListEntry> setSelectedEntry) {
        this.worldSummary = worldSummary;
        this.saveLoader = saveLoader;
        this.setSelectedEntry = setSelectedEntry;
        this.client = class_310.method_1551();
        this.iconLocation = new class_2960("worlds/" + Hashing.sha1().hashUnencodedChars((CharSequence)worldSummary.method_248()) + "/icon");
        this.iconFile = worldSummary.method_27020();
        if (!this.iconFile.isFile()) {
            this.iconFile = null;
        }
        this.icon = this.loadIcon();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX > (double)this.getX() && mouseX < (double)(this.getX() + 310) && mouseY > (double)this.getY() && mouseY < (double)(this.getY() + this.getControlHeight());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        this.setSelectedEntry.accept(this);
        if (class_156.method_658() - this.lastClickTime < 250L) {
            this.done();
        } else {
            this.lastClickTime = class_156.method_658();
        }
        return true;
    }

    @Override
    public void done() {
        String fileName = this.worldSummary.method_248();
        class_32.class_5143 worldInfo = null;
        try {
            worldInfo = this.saveLoader.method_27002(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            long seed = class_2507.method_10629((InputStream)new FileInputStream(worldInfo.method_27010(class_5218.field_24184).toFile())).method_10562("Data").method_10562("WorldGenSettings").method_10537("seed");
            worldInfo.close();
            ClientInterop.saveLoaded(fileName, seed);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class_1043 loadIcon() {
        class_1043 class_10432;
        if (this.iconFile == null || !this.iconFile.isFile()) {
            this.client.method_1531().method_4615(this.iconLocation);
            return null;
        }
        FileInputStream stream = new FileInputStream(this.iconFile);
        try {
            class_1043 texture = new class_1043(class_1011.method_4309((InputStream)stream));
            this.client.method_1531().method_4616(this.iconLocation, (class_1044)texture);
            class_10432 = texture;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable exception) {
                LOGGER.error("Invalid icon for world {}", (Object)this.worldSummary.method_248(), (Object)exception);
                this.iconFile = null;
                return null;
            }
        }
        ((InputStream)stream).close();
        return class_10432;
    }

    @Override
    public void render(class_4587 matrixStack, int mouseX, int mouseY) {
        String displayName = this.worldSummary.method_252();
        String details = this.worldSummary.method_248() + " (" + DATE_FORMAT.format(new Date(this.worldSummary.method_249())) + ")";
        int x = this.getX();
        int y = this.getY();
        this.client.field_1772.method_1729(matrixStack, displayName, (float)(x + 20 + 3), (float)(y + 1), 0xFFFFFF);
        class_327 class_3273 = this.client.field_1772;
        float f = x + 20 + 3;
        Objects.requireNonNull(this.client.field_1772);
        class_3273.method_1729(matrixStack, details, f, (float)(y + 1 + 9 + 1), 0x808080);
        this.client.method_1531().method_22813(this.icon != null ? this.iconLocation : ICON_MISSING);
        RenderHelper.enableBlend();
        class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)20, (int)20, (int)32, (int)32);
        RenderHelper.disableBlend();
    }

    @Override
    public void filter(String lowerValue) {
        super.setVisible(lowerValue.isEmpty() || this.worldSummary.method_252().toLowerCase().contains(lowerValue) || this.worldSummary.method_248().toLowerCase().contains(lowerValue));
    }

    @Override
    public void close() {
        if (this.icon != null) {
            this.icon.close();
        }
    }

    @Override
    public int compareTo(WorldSaveRow other) {
        return this.worldSummary.method_251(other.worldSummary);
    }
}

