/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.client.ClientRenderer;
import com.irtimaled.bbor.client.commands.ConfigCommand;
import com.irtimaled.bbor.client.commands.CustomCommand;
import com.irtimaled.bbor.client.commands.SeedCommand;
import com.irtimaled.bbor.client.commands.SpawningSphereCommand;
import com.irtimaled.bbor.client.commands.StructuresCommand;
import com.irtimaled.bbor.client.events.DisconnectedFromRemoteServer;
import com.irtimaled.bbor.client.events.SaveLoaded;
import com.irtimaled.bbor.client.events.UpdateWorldSpawnReceived;
import com.irtimaled.bbor.client.interop.BiomeBorderHelper;
import com.irtimaled.bbor.client.interop.SaveGameStructureLoader;
import com.irtimaled.bbor.client.providers.SlimeChunkProvider;
import com.irtimaled.bbor.common.EventBus;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.DimensionId;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ClientInterop {
    public static void disconnectedFromRemoteServer() {
        SaveGameStructureLoader.clear();
        BiomeBorderHelper.onDisconnect();
        EventBus.publish(new DisconnectedFromRemoteServer());
    }

    public static void render(class_4587 matrixStack, class_746 player) {
        ClientRenderer.render(matrixStack, DimensionId.from((class_5321<class_1937>)player.method_5770().method_27983()));
    }

    public static boolean interceptChatMessage(String message) {
        if (message.startsWith("/bbor:")) {
            block6: {
                class_634 connection = class_310.method_1551().method_1562();
                if (connection != null) {
                    CommandDispatcher commandDispatcher = connection.method_2886();
                    class_2168 commandSource = class_310.method_1551().field_1724.method_5671();
                    try {
                        commandDispatcher.execute(message.substring(1), (Object)commandSource);
                    }
                    catch (CommandSyntaxException exception) {
                        commandSource.method_9213(class_2564.method_10883((Message)exception.getRawMessage()));
                        if (exception.getInput() == null || exception.getCursor() < 0) break block6;
                        class_5250 suggestion = new class_2585("").method_27692(class_124.field_1080).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, message)));
                        int textLength = Math.min(exception.getInput().length(), exception.getCursor());
                        if (textLength > 10) {
                            suggestion.method_27693("...");
                        }
                        suggestion.method_27693(exception.getInput().substring(Math.max(0, textLength - 10), textLength));
                        if (textLength < exception.getInput().length()) {
                            suggestion.method_10852((class_2561)new class_2585(exception.getInput().substring(textLength)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073}));
                        }
                        suggestion.method_10852((class_2561)new class_2588("command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                        commandSource.method_9213((class_2561)suggestion);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void updateWorldSpawnReceived(class_2338 blockPos) {
        EventBus.publish(new UpdateWorldSpawnReceived(blockPos.method_10263(), blockPos.method_10260()));
    }

    public static int getRenderDistanceChunks() {
        return class_310.method_1551().field_1690.field_1870;
    }

    public static void handleSeedMessage(class_2561 chatComponent) {
        TypeHelper.doIfType(chatComponent, class_2588.class, message -> {
            if (!message.method_11022().equals("commands.seed.success")) {
                return;
            }
            try {
                long seed = Long.parseLong(message.method_11023()[0].toString());
                SlimeChunkProvider.setSeed(seed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void registerClientCommands(CommandDispatcher<class_2172> commandDispatcher) {
        SeedCommand.register(commandDispatcher);
        SpawningSphereCommand.register(commandDispatcher);
        CustomCommand.register(commandDispatcher);
        ConfigCommand.register(commandDispatcher);
        StructuresCommand.register(commandDispatcher);
    }

    public static void receivedChunk(int chunkX, int chunkZ) {
        SaveGameStructureLoader.loadStructures(chunkX, chunkZ);
        BiomeBorderHelper.onChunkLoaded(chunkX, chunkZ);
    }

    public static void unloadChunk(int chunkX, int chunkZ) {
        BiomeBorderHelper.onChunkUnload(chunkX, chunkZ);
    }

    public static void saveLoaded(String fileName, long seed) {
        ClientInterop.displayScreen(null);
        class_310.method_1551().field_1729.method_1612();
        ClientInterop.clearStructures();
        SlimeChunkProvider.setSeed(seed);
        SaveGameStructureLoader.loadSaveGame(fileName);
    }

    public static void clearStructures() {
        EventBus.publish(new SaveLoaded());
        SaveGameStructureLoader.clear();
    }

    public static void displayScreen(class_437 screen) {
        class_310.method_1551().method_1507(screen);
    }

    public static long getGameTime() {
        return class_310.method_1551().field_1687.method_8510();
    }
}

