/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.common.EventBus;
import com.irtimaled.bbor.common.ReflectionHelper;
import com.irtimaled.bbor.common.events.StructuresLoaded;
import com.irtimaled.bbor.common.models.DimensionId;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_26;
import net.minecraft.class_2794;
import net.minecraft.class_2867;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3341;
import net.minecraft.class_3360;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6624;
import net.minecraft.class_6625;

class NBTStructureLoader {
    private final DimensionId dimensionId;
    private final Set<String> loadedChunks = new HashSet<String>();
    private class_3360 legacyStructureDataUtil = null;
    private class_32.class_5143 saveHandler = null;
    private Path chunkSaveLocation = null;
    private ChunkLoader chunkLoader;

    NBTStructureLoader(DimensionId dimensionId, class_32.class_5143 saveHandler, Path worldDirectory) {
        this.dimensionId = dimensionId;
        this.configure(saveHandler, worldDirectory);
    }

    void clear() {
        this.legacyStructureDataUtil = null;
        this.chunkSaveLocation = null;
        this.loadedChunks.clear();
        this.close(new AutoCloseable[]{this.saveHandler, this.chunkLoader});
        this.saveHandler = null;
        this.chunkLoader = null;
    }

    private void close(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void configure(class_32.class_5143 saveHandler, Path worldDirectory) {
        this.saveHandler = saveHandler;
        if (worldDirectory != null) {
            this.chunkSaveLocation = class_2874.method_12488(this.dimensionId.getDimensionType(), (Path)worldDirectory).resolve("region");
            this.chunkLoader = new ChunkLoader(this.chunkSaveLocation);
        }
    }

    private class_3360 getLegacyStructureDataUtil() {
        if (this.legacyStructureDataUtil == null) {
            Path dataFolder = this.saveHandler.method_27424(class_1937.field_25179).resolve("data");
            this.legacyStructureDataUtil = class_3360.method_14745(this.dimensionId.getDimensionType(), (class_26)new class_26(dataFolder.toFile(), class_310.method_1551().method_1543()));
        }
        return this.legacyStructureDataUtil;
    }

    private class_2487 loadStructureStarts(int chunkX, int chunkZ) {
        try {
            int dataVersion;
            class_2487 compound = this.chunkLoader.readChunk(chunkX, chunkZ);
            if (compound == null) {
                return null;
            }
            int n = dataVersion = compound.method_10573("DataVersion", 99) ? compound.method_10550("DataVersion") : -1;
            if (dataVersion < 1493 && compound.method_10562("Level").method_10577("hasLegacyStructureData")) {
                compound = this.getLegacyStructureDataUtil().method_14735(compound);
            }
            return compound.method_10562("Level").method_10562("Structures").method_10562("Starts");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void loadStructures(int chunkX, int chunkZ) {
        if (this.saveHandler == null) {
            return;
        }
        if (!this.loadedChunks.add(String.format("%s,%s", chunkX, chunkZ))) {
            return;
        }
        class_2487 structureStarts = this.loadStructureStarts(chunkX, chunkZ);
        if (structureStarts == null || structureStarts.method_10546() == 0) {
            return;
        }
        HashMap<String, class_3449> structureStartMap = new HashMap<String, class_3449>();
        for (String key : structureStarts.method_10541()) {
            class_2487 compound = structureStarts.method_10562(key);
            if (!compound.method_10545("BB")) continue;
            structureStartMap.put(key, new SimpleStructureStart(compound));
        }
        EventBus.publish(new StructuresLoaded(structureStartMap, this.dimensionId));
    }

    private static class ChunkLoader
    implements AutoCloseable {
        private static final BiFunction<Path, Boolean, class_2867> creator = ReflectionHelper.getPrivateInstanceBuilder(class_2867.class, Path.class, Boolean.TYPE);
        private final class_2867 regionFileCache;

        public ChunkLoader(Path file) {
            this.regionFileCache = creator.apply(file, false);
        }

        public class_2487 readChunk(int chunkX, int chunkZ) throws IOException {
            if (this.regionFileCache == null) {
                return null;
            }
            return this.regionFileCache.method_17911(new class_1923(chunkX, chunkZ));
        }

        @Override
        public void close() throws IOException {
            if (this.regionFileCache == null) {
                return;
            }
            this.regionFileCache.close();
        }
    }

    private static class SimpleStructureStart
    extends class_3449 {
        private final class_3341 parsedBoundingBox;

        SimpleStructureStart(class_2487 compound) {
            super(null, new class_1923(0, 0), 0, new class_6624(SimpleStructureStart.createList(compound)));
            this.parsedBoundingBox = SimpleStructureStart.create(compound.method_10561("BB"));
        }

        private static List<class_3443> createList(class_2487 compound) {
            ArrayList<class_3443> pieces = new ArrayList<class_3443>();
            class_2499 children = compound.method_10554("Children", 10);
            for (int index = 0; index < children.size(); ++index) {
                class_2487 child = children.method_10602(index);
                if (!child.method_10545("BB")) continue;
                pieces.add(new SimpleStructurePiece(child));
            }
            return pieces;
        }

        private static class_3341 create(int[] compound) {
            if (compound.length == 6) {
                return new class_3341(compound[0], compound[1], compound[2], compound[3], compound[4], compound[5]);
            }
            return new class_3341(0, 0, 0, 0, 0, 0);
        }

        public void method_14974(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 chunkBox, class_1923 chunkPos) {
        }

        public class_3341 method_14969() {
            return this.parsedBoundingBox;
        }
    }

    private static class SimpleStructurePiece
    extends class_3443 {
        SimpleStructurePiece(class_2487 compound) {
            super(null, compound);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
        }

        public void method_14931(class_5281 structureWorldAccess, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
        }
    }
}

