/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.interop.NBTStructureLoader;
import com.irtimaled.bbor.common.models.DimensionId;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_32;

public class SaveGameStructureLoader {
    private static final Map<DimensionId, NBTStructureLoader> nbtStructureLoaders = new HashMap<DimensionId, NBTStructureLoader>();
    private static class_32.class_5143 saveHandler = null;
    private static Path worldDirectory = null;

    static void loadSaveGame(String fileName) {
        class_310 minecraft = class_310.method_1551();
        class_32 saveLoader = minecraft.method_1586();
        try {
            saveHandler = saveLoader.method_27002(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        worldDirectory = saveLoader.method_19636().resolve(fileName);
        for (DimensionId dimensionId : nbtStructureLoaders.keySet()) {
            NBTStructureLoader dimensionProcessor = SaveGameStructureLoader.getNBTStructureLoader(dimensionId);
            dimensionProcessor.configure(saveHandler, worldDirectory);
        }
        SaveGameStructureLoader.loadChunksAroundPlayer();
    }

    private static void loadChunksAroundPlayer() {
        NBTStructureLoader dimensionProcessor = SaveGameStructureLoader.getNBTStructureLoader(Player.getDimensionId());
        int renderDistance = ClientInterop.getRenderDistanceChunks();
        int playerChunkX = (int)Player.getX() >> 4;
        int minChunkX = playerChunkX - renderDistance;
        int maxChunkX = playerChunkX + renderDistance;
        int playerChunkZ = (int)Player.getZ() >> 4;
        int minChunkZ = playerChunkZ - renderDistance;
        int maxChunkZ = playerChunkZ + renderDistance;
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                dimensionProcessor.loadStructures(chunkX, chunkZ);
            }
        }
    }

    static void loadStructures(int chunkX, int chunkZ) {
        NBTStructureLoader dimensionProcessor = SaveGameStructureLoader.getNBTStructureLoader(Player.getDimensionId());
        dimensionProcessor.loadStructures(chunkX, chunkZ);
    }

    private static NBTStructureLoader getNBTStructureLoader(DimensionId dimensionId) {
        return nbtStructureLoaders.computeIfAbsent(dimensionId, id -> new NBTStructureLoader((DimensionId)id, saveHandler, worldDirectory));
    }

    public static void clear() {
        nbtStructureLoaders.values().forEach(NBTStructureLoader::clear);
        nbtStructureLoaders.clear();
        saveHandler = null;
        worldDirectory = null;
    }
}

