/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.mixin.client.access.IClientChunkManager;
import com.irtimaled.bbor.mixin.client.access.IClientChunkManagerClientChunkMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_310;

public class TileEntitiesHelper {
    private static Collection<class_2586> tileEntities = null;

    private static Collection<class_2586> getTileEntities() {
        if (tileEntities == null) {
            AtomicReferenceArray<class_2818> chunks = ((IClientChunkManagerClientChunkMap)((IClientChunkManager)class_310.method_1551().field_1687.method_2935()).getChunks()).getChunks();
            ArrayList<class_2586> tileEntities = new ArrayList<class_2586>();
            for (int i = 0; i < chunks.length(); ++i) {
                class_2818 worldChunk = chunks.get(i);
                if (worldChunk == null) continue;
                tileEntities.addAll(worldChunk.method_12214().values());
            }
            TileEntitiesHelper.tileEntities = tileEntities;
            return tileEntities;
        }
        return tileEntities;
    }

    public static void clearCache() {
        tileEntities = null;
    }

    public static <T extends class_2586, S extends AbstractBoundingBox> Iterable<S> map(Class<T> clazz, Function<T, S> map) {
        Collection<class_2586> tileEntities = TileEntitiesHelper.getTileEntities();
        HashSet<AbstractBoundingBox> results = new HashSet<AbstractBoundingBox>();
        for (class_2586 tileEntity : tileEntities) {
            AbstractBoundingBox result;
            class_2586 typed = (class_2586)TypeHelper.as(tileEntity, clazz);
            if (typed == null || (result = (AbstractBoundingBox)map.apply(typed)) == null) continue;
            results.add(result);
        }
        return results;
    }
}

