/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.keyboard;

import com.irtimaled.bbor.client.keyboard.KeyHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_3675;

public class Key {
    private int keyCode;
    private KeyHandler onKeyPress;
    private final Set<Key> subKeys = new HashSet<Key>();
    private boolean triggeredSincePress;
    private int pressDuration = 0;

    Key(int keyCode) {
        this.keyCode = keyCode;
    }

    public Key onKeyPressHandler(KeyHandler onKeyPress) {
        this.onKeyPress = onKeyPress;
        return this;
    }

    void updateKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    private void runHandler(KeyHandler onKeyPress) {
        this.triggeredSincePress = true;
        onKeyPress.handle();
    }

    private void press() {
        for (Key subKey : this.subKeys) {
            subKey.triggeredSincePress = false;
        }
        this.triggeredSincePress = false;
        ++this.pressDuration;
    }

    private void release() {
        try {
            for (Key subKey : this.subKeys) {
                if (subKey.pressDuration > 0) {
                    subKey.release();
                    return;
                }
                if (!subKey.triggeredSincePress) continue;
                return;
            }
            if (this.onKeyPress != null && this.pressDuration > 0) {
                this.runHandler(this.onKeyPress);
            }
        }
        finally {
            this.pressDuration = 0;
        }
    }

    boolean handleKeyEvent(int keyCode, boolean isPressed) {
        if (this.keyCode == keyCode) {
            if (isPressed) {
                this.press();
            } else {
                this.release();
            }
            return true;
        }
        if (this.pressDuration > 0) {
            for (Key subKey : this.subKeys) {
                if (!subKey.handleKeyEvent(keyCode, isPressed)) continue;
                return true;
            }
        }
        return false;
    }

    public Key register(String keyName) {
        class_3675.class_306 input = class_3675.method_15981((String)keyName);
        Key key = new Key(input.method_1444());
        this.subKeys.add(key);
        return key;
    }
}

