/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.BeaconRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.interop.CommonInterop;
import com.irtimaled.bbor.common.models.BoundingBoxCuboid;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxBeacon
extends BoundingBoxCuboid {
    private static final AbstractRenderer<BoundingBoxBeacon> RENDERER = CommonInterop.registerRenderer(BoundingBoxBeacon.class, () -> new BeaconRenderer());
    private final Coords coords;
    private final int level;

    private BoundingBoxBeacon(Coords coords, Coords minCoords, Coords maxCoords, int level, BoundingBoxType type) {
        super(minCoords, maxCoords, type);
        this.coords = coords;
        this.level = level;
    }

    public static BoundingBoxBeacon from(Coords coords, int level) {
        return BoundingBoxBeacon.from(coords, level, BoundingBoxType.Beacon);
    }

    public static BoundingBoxBeacon from(Coords coords, int level, BoundingBoxType type) {
        int range = 10 + 10 * level;
        Coords minCoords = new Coords(coords.getX() - range, coords.getY() - range, coords.getZ() - range);
        Coords maxCoords = new Coords(coords.getX() + range, 324 + range, coords.getZ() + range);
        return new BoundingBoxBeacon(coords, minCoords, maxCoords, level, type);
    }

    @Override
    public int hashCode() {
        return this.coords.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxBeacon other = (BoundingBoxBeacon)obj;
        return this.coords.equals(other.coords);
    }

    public Coords getCoords() {
        return this.coords;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public AbstractRenderer<?> getRenderer() {
        return RENDERER;
    }
}

