/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.RenderCulling;
import com.irtimaled.bbor.client.config.ColorHelper;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.FlowerForestRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.interop.CommonInterop;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.Coords;
import java.awt.Color;

public class BoundingBoxFlowerForest
extends AbstractBoundingBox {
    private static final AbstractRenderer<BoundingBoxFlowerForest> RENDERER = CommonInterop.registerRenderer(BoundingBoxFlowerForest.class, () -> new FlowerForestRenderer());
    private final Coords coords;
    private final Setting<HexColor> colorSetting;

    public BoundingBoxFlowerForest(Coords coords, Setting<HexColor> colorSetting) {
        super(BoundingBoxType.FlowerForest);
        this.coords = coords;
        this.colorSetting = colorSetting;
    }

    @Override
    public Boolean intersectsBounds(int minX, int minZ, int maxX, int maxZ) {
        return this.coords.getX() >= minX && this.coords.getZ() >= minZ && this.coords.getX() <= maxX && this.coords.getZ() <= maxZ;
    }

    public Color getColor() {
        return ColorHelper.getColor(this.colorSetting);
    }

    public Coords getCoords() {
        return this.coords;
    }

    @Override
    public double getDistanceX(double x) {
        return x - (double)this.coords.getX();
    }

    @Override
    public double getDistanceY(double y) {
        return y - (double)this.coords.getY();
    }

    @Override
    public double getDistanceZ(double z) {
        return z - (double)this.coords.getZ();
    }

    @Override
    public AbstractRenderer<?> getRenderer() {
        return RENDERER;
    }

    @Override
    public boolean isVisibleCulling() {
        return RenderCulling.isVisibleCulling(this.coords.getX(), (double)this.coords.getY() + 0.01, this.coords.getZ(), this.coords.getX() + 1, this.coords.getY(), this.coords.getZ() + 1);
    }
}

