/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.RenderCulling;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.LineRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.interop.CommonInterop;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;

public class BoundingBoxLine
extends AbstractBoundingBox {
    private static final AbstractRenderer<BoundingBoxLine> RENDERER = CommonInterop.registerRenderer(BoundingBoxLine.class, () -> new LineRenderer());
    private final Point minPoint;
    private final Point maxPoint;
    private final Double width;
    private final Point[] corners;

    protected BoundingBoxLine(Point minPoint, Point maxPoint, double width, BoundingBoxType type, Point ... corners) {
        super(type);
        this.minPoint = minPoint;
        this.maxPoint = maxPoint;
        this.width = width;
        this.corners = corners;
    }

    public static BoundingBoxLine from(Point minPoint, Point maxPoint, Double width, BoundingBoxType type) {
        double zc;
        double xc;
        double dzm;
        if (width == 0.0) {
            return new BoundingBoxLine(minPoint, maxPoint, width, type, new Point[0]);
        }
        double halfWidth = width / 2.0;
        double dx = maxPoint.getX() - minPoint.getX();
        double dz = maxPoint.getZ() - minPoint.getZ();
        double dxm = dx == 0.0 ? 0.0 : dx / Math.abs(dx);
        double d = dzm = dz == 0.0 ? 0.0 : dz / Math.abs(dz);
        if (dxm == 0.0 || dzm == 0.0) {
            xc = Math.abs(dzm) * halfWidth;
            zc = Math.abs(dxm) * halfWidth;
        } else {
            double h = Math.sqrt(dx * dx + dz * dz);
            double theta = Math.acos((dz * dz + h * h - dx * dx) / (2.0 * dz * h));
            zc = halfWidth * Math.sin(theta);
            xc = Math.sqrt(halfWidth * halfWidth - zc * zc) * dxm * dzm;
        }
        return new BoundingBoxLine(minPoint, maxPoint, width, type, new Point(minPoint.getX() + xc, minPoint.getY(), minPoint.getZ() - zc), new Point(minPoint.getX() - xc, minPoint.getY(), minPoint.getZ() + zc), new Point(maxPoint.getX() - xc, maxPoint.getY(), maxPoint.getZ() + zc), new Point(maxPoint.getX() + xc, maxPoint.getY(), maxPoint.getZ() - zc));
    }

    public int hashCode() {
        return TypeHelper.combineHashCodes(this.minPoint.hashCode(), this.maxPoint.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxLine other = (BoundingBoxLine)obj;
        return this.minPoint.equals(other.minPoint) && this.maxPoint.equals(other.maxPoint);
    }

    public Point getMinPoint() {
        return this.minPoint;
    }

    public Point getMaxPoint() {
        return this.maxPoint;
    }

    public double getWidth() {
        return this.width;
    }

    public Point[] getCorners() {
        return this.corners;
    }

    @Override
    public Boolean intersectsBounds(int minX, int minZ, int maxX, int maxZ) {
        boolean minXWithinBounds = this.isBetween(this.minPoint.getX(), minX, maxX);
        boolean maxXWithinBounds = this.isBetween(this.maxPoint.getX(), minX, maxX);
        boolean minZWithinBounds = this.isBetween(this.minPoint.getZ(), minZ, maxZ);
        boolean maxZWithinBounds = this.isBetween(this.maxPoint.getZ(), minZ, maxZ);
        return minXWithinBounds && minZWithinBounds || maxXWithinBounds && maxZWithinBounds || minXWithinBounds && maxZWithinBounds || maxXWithinBounds && minZWithinBounds;
    }

    @Override
    protected double getDistanceX(double x) {
        return x - MathHelper.clamp(x, this.minPoint.getX(), this.maxPoint.getX());
    }

    @Override
    protected double getDistanceY(double y) {
        return y - MathHelper.clamp(y, this.minPoint.getY(), this.maxPoint.getY());
    }

    @Override
    protected double getDistanceZ(double z) {
        return z - MathHelper.clamp(z, this.minPoint.getZ(), this.maxPoint.getZ());
    }

    private boolean isBetween(double val, int min, int max) {
        return val >= (double)min && val <= (double)max;
    }

    @Override
    public AbstractRenderer<?> getRenderer() {
        return RENDERER;
    }

    @Override
    public boolean isVisibleCulling() {
        return RenderCulling.isVisibleCulling(this.minPoint.getX(), this.minPoint.getY(), this.minPoint.getZ(), this.maxPoint.getX(), this.maxPoint.getY(), this.maxPoint.getZ());
    }
}

