/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.SlimeChunkRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.interop.CommonInterop;
import com.irtimaled.bbor.common.models.BoundingBoxCuboid;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxSlimeChunk
extends BoundingBoxCuboid {
    private static final AbstractRenderer<BoundingBoxSlimeChunk> RENDERER = CommonInterop.registerRenderer(BoundingBoxSlimeChunk.class, () -> new SlimeChunkRenderer());

    public BoundingBoxSlimeChunk(Coords minCoords, Coords maxCoords) {
        super(minCoords, maxCoords, BoundingBoxType.SlimeChunks);
    }

    @Override
    public double getDistanceY(double y) {
        double maxY = Player.getMaxY(ConfigManager.slimeChunkMaxY.get().intValue());
        if (maxY > 39.0) {
            return y - MathHelper.clamp(y, 0.0, maxY);
        }
        return super.getDistanceY(y);
    }

    public AbstractRenderer<BoundingBoxSlimeChunk> getRenderer() {
        return RENDERER;
    }
}

