/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.Coords;
import net.minecraft.class_243;

public class Point {
    private final double x;
    private final double y;
    private final double z;

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(Coords Coords2) {
        this.x = Coords2.getX();
        this.y = Coords2.getY();
        this.z = Coords2.getZ();
    }

    public Point(class_243 pos) {
        this.x = pos.field_1352;
        this.y = pos.field_1351;
        this.z = pos.field_1350;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Point offset(double x, double y, double z) {
        return new Point(this.x + x, this.y + y, this.z + z);
    }

    public Point snapXZ(double nearest) {
        double x = MathHelper.snapToNearest(this.x, nearest);
        double z = MathHelper.snapToNearest(this.z, nearest);
        return new Point(x, this.y, z);
    }

    public double getDistance(Point point) {
        double dx = this.x - point.x;
        double dy = this.y - point.y;
        double dz = this.z - point.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public Coords getCoords() {
        return new Coords(this.x, this.y, this.z);
    }

    public int hashCode() {
        return TypeHelper.combineHashCodes(Double.hashCode(this.z), Double.hashCode(this.y), Double.hashCode(this.x));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Point point = (Point)obj;
        return this.getX() == point.getX() && this.getY() == point.getY() && this.getZ() == point.getZ();
    }
}

