/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.interop.BedrockCeilingHelper;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.models.BoundingBoxBedrockCeiling;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BedrockCeilingProvider
implements IBoundingBoxProvider<BoundingBoxBedrockCeiling>,
ICachingProvider {
    private static final double CHUNK_SIZE = 16.0;
    private static Long lastGameTime = null;
    private static final Map<String, BedrockChunk> chunks = new HashMap<String, BedrockChunk>();

    @Override
    public void clearCache() {
        chunks.values().forEach(BedrockChunk::clear);
        chunks.clear();
    }

    @Override
    public Iterable<BoundingBoxBedrockCeiling> get(DimensionId dimensionId) {
        boolean shouldRecalculate = this.shouldRecalculate();
        int renderDistanceChunks = ClientInterop.getRenderDistanceChunks() / 2;
        int playerChunkX = MathHelper.floor(Player.getX() / 16.0);
        int playerChunkZ = MathHelper.floor(Player.getZ() / 16.0);
        ArrayList<BoundingBoxBedrockCeiling> boxes = new ArrayList<BoundingBoxBedrockCeiling>();
        for (int chunkX = playerChunkX - renderDistanceChunks; chunkX <= playerChunkX + renderDistanceChunks; ++chunkX) {
            for (int chunkZ = playerChunkZ - renderDistanceChunks; chunkZ <= playerChunkZ + renderDistanceChunks; ++chunkZ) {
                String key = String.format("%d,%d", chunkX, chunkZ);
                if (shouldRecalculate || !chunks.containsKey(key)) {
                    chunks.put(key, new BedrockChunk(chunkX, chunkZ));
                }
                BedrockChunk chunk = chunks.get(key);
                boxes.addAll(chunk.getBlocks());
            }
        }
        return boxes;
    }

    public boolean shouldRecalculate() {
        long gameTime = ClientInterop.getGameTime();
        if (!Long.valueOf(gameTime).equals(lastGameTime) && (gameTime & 0xFL) == 0L) {
            lastGameTime = gameTime;
            return true;
        }
        return false;
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return dimensionId == DimensionId.NETHER && BoundingBoxTypeHelper.shouldRender(BoundingBoxType.BedrockCeiling) && Player.getY() > 110.0;
    }

    private static class BedrockChunk {
        private final List<BoundingBoxBedrockCeiling> boxes = new ObjectArrayList();

        public BedrockChunk(int chunkX, int chunkZ) {
            int chunkStartX = chunkX << 4;
            int chunkStartZ = chunkZ << 4;
            if (BedrockCeilingHelper.chunkLoaded(chunkX, chunkZ)) {
                this.findBoxesFromBlockState(chunkStartX, chunkStartZ);
            }
        }

        private void findBoxesFromBlockState(int chunkStartX, int chunkStartZ) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Coords coords = this.getCoordsFromBlockState(chunkStartX + x, chunkStartZ + z);
                    if (coords == null) continue;
                    this.boxes.add(new BoundingBoxBedrockCeiling(coords));
                }
            }
        }

        private Coords getCoordsFromBlockState(int x, int z) {
            Coords coords = null;
            for (int y = 127; y >= 123; --y) {
                if (!BedrockCeilingHelper.isBedrock(x, y, z)) continue;
                if (coords == null) {
                    coords = new Coords(x, y, z);
                    continue;
                }
                return null;
            }
            return coords;
        }

        public Collection<? extends BoundingBoxBedrockCeiling> getBlocks() {
            return this.boxes;
        }

        public void clear() {
            this.boxes.clear();
        }
    }
}

