/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.interop.BlockProcessor;
import com.irtimaled.bbor.client.interop.SpawningSphereHelper;
import com.irtimaled.bbor.client.models.BoundingBoxSpawningSphere;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_310;

public class SpawningSphereProvider
implements IBoundingBoxProvider<BoundingBoxSpawningSphere>,
ICachingProvider {
    public static final class_310 minecraft = class_310.method_1551();
    private static Long lastGameTime = null;
    private static Set<BoundingBoxSpawningSphere> lastBoundingBox = null;
    private static BoundingBoxSpawningSphere spawningSphere;
    private static DimensionId dimensionId;

    public static void setSphere(Point point) {
        if (spawningSphere != null && spawningSphere.getPoint().equals(point)) {
            return;
        }
        dimensionId = Player.getDimensionId();
        spawningSphere = new BoundingBoxSpawningSphere(point);
        lastBoundingBox = null;
    }

    public static boolean clearSphere() {
        if (spawningSphere != null) {
            lastBoundingBox = null;
            spawningSphere = null;
            dimensionId = null;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        SpawningSphereProvider.clearSphere();
    }

    public static void calculateSpawnableSpacesCount(BlockProcessor blockProcessor) {
        if (spawningSphere != null) {
            Point sphereCenter = spawningSphere.getPoint();
            int size = 130;
            SpawningSphereHelper.findSpawnableSpaces(sphereCenter, sphereCenter.getCoords(), size, size, blockProcessor);
        }
    }

    static boolean playerInsideSphere() {
        return SpawningSphereProvider.hasSpawningSphereInDimension(Player.getDimensionId()) && spawningSphere.isWithinSphere(Player.getPoint());
    }

    public static boolean hasSpawningSphereInDimension(DimensionId dimensionId) {
        return spawningSphere != null && SpawningSphereProvider.dimensionId == dimensionId;
    }

    public static void setSpawnableSpacesCount(int count) {
        if (spawningSphere != null) {
            spawningSphere.setSpawnableCount(count);
        }
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return SpawningSphereProvider.hasSpawningSphereInDimension(dimensionId) && BoundingBoxTypeHelper.shouldRender(BoundingBoxType.AFKSphere);
    }

    @Override
    public Iterable<BoundingBoxSpawningSphere> get(DimensionId dimensionId) {
        long gameTime = SpawningSphereProvider.minecraft.field_1687.method_8510();
        if (lastBoundingBox == null || !Long.valueOf(gameTime).equals(lastGameTime) && gameTime % 2L == 0L) {
            lastGameTime = gameTime;
            lastBoundingBox = this.getSpawningSphere();
        }
        return lastBoundingBox;
    }

    private Set<BoundingBoxSpawningSphere> getSpawningSphere() {
        spawningSphere.getBlocks().clear();
        if (ConfigManager.renderAFKSpawnableBlocks.get().booleanValue()) {
            int width = MathHelper.floor(Math.pow(2.0, 1 + ConfigManager.spawnableBlocksRenderWidth.get()));
            int height = MathHelper.floor(Math.pow(2.0, ConfigManager.spawnableBlocksRenderHeight.get().intValue()));
            SpawningSphereHelper.findSpawnableSpaces(spawningSphere.getPoint(), Player.getCoords(), width, height, spawningSphere.getBlocks()::add);
        }
        HashSet<BoundingBoxSpawningSphere> boundingBoxes = new HashSet<BoundingBoxSpawningSphere>();
        boundingBoxes.add(spawningSphere);
        return boundingBoxes;
    }
}

