/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.models.BoundingBoxWorldSpawn;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashSet;

public class WorldSpawnProvider
implements IBoundingBoxProvider<BoundingBoxWorldSpawn>,
ICachingProvider {
    private static final double CHUNK_SIZE = 16.0;
    private static BoundingBoxWorldSpawn spawnChunks;
    private static BoundingBoxWorldSpawn lazyChunks;
    private static BoundingBoxWorldSpawn worldSpawn;

    public static void setWorldSpawn(int spawnX, int spawnZ) {
        worldSpawn = WorldSpawnProvider.getWorldSpawnBoundingBox(spawnX, spawnZ);
        spawnChunks = WorldSpawnProvider.buildSpawnChunksBoundingBox(spawnX, spawnZ, 19, BoundingBoxType.SpawnChunks);
        lazyChunks = WorldSpawnProvider.buildSpawnChunksBoundingBox(spawnX, spawnZ, 21, BoundingBoxType.LazySpawnChunks);
    }

    @Override
    public void clearCache() {
        worldSpawn = null;
        spawnChunks = null;
        lazyChunks = null;
    }

    private static BoundingBoxWorldSpawn getWorldSpawnBoundingBox(int spawnX, int spawnZ) {
        Coords minCoords = new Coords(spawnX - 10, 0, spawnZ - 10);
        Coords maxCoords = new Coords(spawnX + 10, 0, spawnZ + 10);
        return new BoundingBoxWorldSpawn(minCoords, maxCoords, BoundingBoxType.WorldSpawn);
    }

    private static BoundingBoxWorldSpawn buildSpawnChunksBoundingBox(int spawnX, int spawnZ, int size, BoundingBoxType type) {
        int spawnChunkX = MathHelper.floor((double)spawnX / 16.0);
        int spawnChunkZ = MathHelper.floor((double)spawnZ / 16.0);
        int midOffset = (size - 1) / 2;
        int minX = spawnChunkX - midOffset;
        int maxX = spawnChunkX + midOffset;
        int minZ = spawnChunkZ - midOffset;
        int maxZ = spawnChunkZ + midOffset;
        Coords maxCoords = new Coords((double)minX * 16.0, 0.0, (double)minZ * 16.0);
        Coords minCoords = new Coords(16.0 + (double)maxX * 16.0, 0.0, 16.0 + (double)maxZ * 16.0);
        return new BoundingBoxWorldSpawn(minCoords, maxCoords, type);
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return dimensionId == DimensionId.OVERWORLD;
    }

    @Override
    public Iterable<BoundingBoxWorldSpawn> get(DimensionId dimensionId) {
        HashSet<BoundingBoxWorldSpawn> boundingBoxes = new HashSet<BoundingBoxWorldSpawn>();
        if (BoundingBoxTypeHelper.shouldRender(BoundingBoxType.WorldSpawn)) {
            if (worldSpawn != null) {
                boundingBoxes.add(worldSpawn);
            }
            if (spawnChunks != null) {
                boundingBoxes.add(spawnChunks);
            }
        }
        if (BoundingBoxTypeHelper.shouldRender(BoundingBoxType.LazySpawnChunks) && lazyChunks != null) {
            boundingBoxes.add(lazyChunks);
        }
        return boundingBoxes;
    }
}

