/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.Camera;
import com.irtimaled.bbor.client.RenderCulling;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.renderers.OffsetBox;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.client.renderers.RenderBatch;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public abstract class AbstractRenderer<T extends AbstractBoundingBox> {
    private static final double TAU = Math.PI * 2;
    public static final double PHI_SEGMENT = 0.06981317007977318;
    private static final double PI = Math.PI;
    public static final double THETA_SEGMENT = Math.PI / 90;
    private static final class_238 ORIGIN_BOX = new class_238(class_2338.field_10980);

    public abstract void render(class_4587 var1, T var2);

    void renderCuboid(class_4587 matrixStack, OffsetBox bb, Color color, boolean fillOnly, int fillAlpha) {
        matrixStack.method_22903();
        this.renderCuboid0(matrixStack, bb.nudge(), color, fillOnly, fillAlpha, false);
        matrixStack.method_22909();
    }

    private void renderCuboid0(class_4587 stack, OffsetBox nudge, Color color, boolean fillOnly, int fillAlpha, boolean mask) {
        if (ConfigManager.fastRender.get() >= 1 && !RenderCulling.isVisibleCulling(nudge.toBox())) {
            return;
        }
        if (ConfigManager.invertBoxColorPlayerInside.get().booleanValue() && this.playerInsideBoundingBox(nudge)) {
            color = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        class_4587.class_4665 lastStack = stack.method_23760();
        stack.method_22903();
        int regionX = (int)Camera.getX() >> 9 << 9;
        int regionZ = (int)Camera.getZ() >> 9 << 9;
        RenderHelper.applyRegionalRenderOffset(stack);
        double minX = nudge.getMin().getX();
        double minY = nudge.getMin().getY();
        double minZ = nudge.getMin().getZ();
        double maxX = nudge.getMax().getX();
        double maxY = nudge.getMax().getY();
        double maxZ = nudge.getMax().getZ();
        stack.method_22904(minX - (double)regionX, minY, minZ - (double)regionZ);
        stack.method_22905((float)(maxX - minX), (float)(maxY - minY), (float)(maxZ - minZ));
        if (fillOnly || ConfigManager.fill.get().booleanValue()) {
            RenderBatch.drawSolidBox(stack.method_23760(), ORIGIN_BOX, color, fillAlpha, mask, minX == maxX, minY == maxY, minZ == maxZ);
        }
        if (!fillOnly) {
            stack.method_22903();
            stack.method_23760().method_23761().method_35434(lastStack.method_23761());
            stack.method_23760().method_23762().method_22852(lastStack.method_23762());
            this.renderLine(stack, new OffsetPoint(minX, minY, minZ), new OffsetPoint(maxX, minY, minZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, minY, minZ), new OffsetPoint(maxX, minY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, minY, maxZ), new OffsetPoint(minX, minY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(minX, minY, maxZ), new OffsetPoint(minX, minY, minZ), color, true);
            this.renderLine(stack, new OffsetPoint(minX, minY, minZ), new OffsetPoint(minX, maxY, minZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, minY, minZ), new OffsetPoint(maxX, maxY, minZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, minY, maxZ), new OffsetPoint(maxX, maxY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(minX, minY, maxZ), new OffsetPoint(minX, maxY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(minX, maxY, minZ), new OffsetPoint(maxX, maxY, minZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, maxY, minZ), new OffsetPoint(maxX, maxY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(maxX, maxY, maxZ), new OffsetPoint(minX, maxY, maxZ), color, true);
            this.renderLine(stack, new OffsetPoint(minX, maxY, maxZ), new OffsetPoint(minX, maxY, minZ), color, true);
            stack.method_22909();
        }
        stack.method_22909();
    }

    private boolean playerInsideBoundingBox(OffsetBox nudge) {
        return nudge.getMin().getX() < 0.0 && nudge.getMax().getX() > 0.0 && nudge.getMin().getY() < 0.0 && nudge.getMax().getY() > 0.0 && nudge.getMin().getZ() < 0.0 && nudge.getMax().getZ() > 0.0;
    }

    void renderLine(class_4587 matrixStack, OffsetPoint startPoint, OffsetPoint endPoint, Color color, boolean cullIfEmpty) {
        if (cullIfEmpty && startPoint.equals(endPoint)) {
            return;
        }
        if (ConfigManager.fastRender.get() >= 1 && !RenderCulling.isVisibleCulling(new OffsetBox(startPoint, endPoint).toBox())) {
            return;
        }
        matrixStack.method_22903();
        RenderHelper.applyRegionalRenderOffset(matrixStack);
        RenderBatch.drawLine(matrixStack.method_23760(), startPoint.getPoint(), endPoint.getPoint(), color, 255);
        matrixStack.method_22909();
    }

    void renderText(class_4587 matrixStack, OffsetPoint offsetPoint, String ... texts) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        RenderHelper.beforeRenderFont(matrixStack, offsetPoint);
        Objects.requireNonNull(fontRenderer);
        float top = (float)(-(9 * texts.length)) / 2.0f;
        for (String text : texts) {
            float left = (float)fontRenderer.method_1727(text) / 2.0f;
            fontRenderer.method_1729(new class_4587(), text, -left, top, -1);
            Objects.requireNonNull(fontRenderer);
            top += 9.0f;
        }
        RenderHelper.afterRenderFont(matrixStack);
    }

    void renderSphere(class_4587 matrixStack, Point center, double radius, Color color) {
        if (ConfigManager.renderSphereAsDots.get().booleanValue()) {
            this.renderDotSphere(matrixStack, center, radius, color);
        } else {
            this.renderFilledSphere(matrixStack, center, radius, color);
        }
    }

    private void renderFilledSphere(class_4587 matrixStack, Point center, double radius, Color color) {
        if (ConfigManager.fastRender.get() >= 1 && !RenderCulling.isVisibleCulling(new class_238(new class_2338(center.getX(), center.getY(), center.getZ())).method_1014(radius))) {
            return;
        }
        ObjectArrayList top = new ObjectArrayList();
        ObjectArrayList bottom = new ObjectArrayList();
        Point topPoint = new Point(center.getX(), center.getY() + radius, center.getZ());
        Point bottomPoint = new Point(center.getX(), center.getY() - radius, center.getZ());
        for (int i = 0; i < 360; i += 4) {
            top.add((Object)topPoint);
            bottom.add((Object)bottomPoint);
        }
        ObjectArrayList points = new ObjectArrayList();
        points.add((Object)bottom);
        for (int i = -90; i <= 90; i += 4) {
            double phi = Math.PI / 180 * (double)i;
            double dy = Math.sin(phi) * radius;
            double circleRadius = Math.cos(phi) * radius;
            if (circleRadius == 0.0) {
                circleRadius = Math.sqrt(2.0) / 2.0;
            }
            ObjectArrayList pointsCache = new ObjectArrayList();
            this.renderCircle(matrixStack, center, circleRadius, color, dy + (double)0.001f, (ObjectArrayList<Point>)pointsCache);
            points.add((Object)pointsCache);
        }
        points.add((Object)top);
        matrixStack.method_22903();
        RenderHelper.applyRegionalRenderOffset(matrixStack);
        RenderSystem.setShader(class_757::method_34539);
        Boolean doFill = ConfigManager.fill.get();
        for (int i = 0; i < points.size() - 1; ++i) {
            ObjectArrayList pointsCache1 = (ObjectArrayList)points.get(i);
            ObjectArrayList pointsCache2 = (ObjectArrayList)points.get(i + 1);
            assert (pointsCache1.size() == pointsCache2.size());
            Point lastPoint1 = null;
            Point lastPoint2 = null;
            int pointsCacheSize = pointsCache1.size();
            for (int j = 0; j < pointsCacheSize; ++j) {
                Point point1 = (Point)pointsCache1.get(j);
                Point point2 = (Point)pointsCache2.get(j);
                if (ConfigManager.fastRender.get() >= 1 && RenderCulling.isVisibleCulling(new OffsetBox(point1, point2).toBox())) {
                    RenderBatch.drawLine(matrixStack.method_23760(), point1, point2, color, 255);
                }
                if (doFill.booleanValue() && lastPoint1 != null && ConfigManager.fastRender.get() >= 1 && RenderCulling.isVisibleCulling(new OffsetBox(lastPoint1, point2).toBox())) {
                    RenderBatch.drawFilledFace(matrixStack.method_23760(), lastPoint1, lastPoint2, point2, point1, color, 127, false);
                }
                lastPoint1 = point1;
                lastPoint2 = point2;
            }
            if (!doFill.booleanValue() || lastPoint1 == null || ConfigManager.fastRender.get() < 1 || !RenderCulling.isVisibleCulling(new OffsetBox((Point)pointsCache1.get(0), lastPoint2).toBox())) continue;
            RenderBatch.drawFilledFace(matrixStack.method_23760(), (Point)pointsCache1.get(0), (Point)pointsCache2.get(0), lastPoint2, lastPoint1, color, 127, false);
        }
        matrixStack.method_22909();
    }

    private void renderLineSphere(class_4587 matrixStack, Point center, double radius, Color color) {
        if (ConfigManager.fastRender.get() >= 1 && !RenderCulling.isVisibleCulling(new class_238(new class_2338(center.getX(), center.getY(), center.getZ())).method_1014(radius))) {
            return;
        }
        double offset = radius - (double)((int)radius) == 0.0 ? center.getY() - (double)((int)center.getY()) : 0.0;
        int dyStep = radius < 64.0 ? 1 : MathHelper.floor(radius / 32.0);
        ObjectArrayList pointsCache = new ObjectArrayList();
        for (double dy = offset - radius; dy <= radius + 1.0; dy += (double)dyStep) {
            double circleRadius = Math.sqrt(radius * radius - dy * dy);
            if (circleRadius == 0.0) {
                circleRadius = Math.sqrt(2.0) / 2.0;
            }
            this.renderCircle(matrixStack, center, circleRadius, color, dy + (double)0.001f, (ObjectArrayList<Point>)pointsCache);
            pointsCache.clear();
        }
    }

    private void renderCircle(class_4587 matrixStack, Point center, double radius, Color color, double dy, ObjectArrayList<Point> cache) {
        matrixStack.method_22903();
        RenderHelper.applyRegionalRenderOffset(matrixStack);
        RenderSystem.setShader(class_757::method_34539);
        this.generateCircle(center, radius, dy, cache);
        Point last = null;
        for (Object _point : cache.elements()) {
            if (_point == null) continue;
            Point point = (Point)_point;
            if (last != null) {
                RenderBatch.drawLine(matrixStack.method_23760(), last, point, color, 255);
            }
            last = point;
        }
        if (last != null) {
            RenderBatch.drawLine(matrixStack.method_23760(), last, (Point)cache.get(0), color, 255);
        }
        matrixStack.method_22909();
    }

    private void generateCircle(Point center, double radius, double dy, ObjectArrayList<Point> cache) {
        for (int i = 0; i < 360; i += 4) {
            double phi = Math.PI / 180 * (double)i;
            Point point = center.offset(Math.cos(phi) * radius, dy, Math.sin(phi) * radius);
            cache.add((Object)point);
        }
    }

    private void renderDotSphere(class_4587 matrixStack, Point center, double radius, Color color) {
        if (ConfigManager.fastRender.get() >= 1 && !RenderCulling.isVisibleCulling(new class_238(new class_2338(center.getX(), center.getY(), center.getZ())).method_1014(radius))) {
            return;
        }
        matrixStack.method_22903();
        for (double phi = 0.0; phi < Math.PI * 2; phi += 0.06981317007977318) {
            double dy = radius * Math.cos(phi);
            double radiusBySinPhi = radius * Math.sin(phi);
            for (double theta = 0.0; theta < Math.PI; theta += Math.PI / 90) {
                double dx = radiusBySinPhi * Math.cos(theta);
                double dz = radiusBySinPhi * Math.sin(theta);
                Point point = center.offset(dx, dy, dz);
                this.renderCuboid0(matrixStack, new OffsetBox(point.offset(-0.0025f, -0.0025f, -0.0025f), point.offset(0.0025f, 0.0025f, 0.0025f)), color, true, 255, true);
            }
        }
        matrixStack.method_22909();
    }
}

