/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.BoundingBoxBiomeBorder;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.OffsetBox;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.common.models.Coords;
import java.awt.Color;
import net.minecraft.class_4587;

public class BiomeBorderRenderer
extends AbstractRenderer<BoundingBoxBiomeBorder> {
    @Override
    public void render(class_4587 matrixStack, BoundingBoxBiomeBorder boundingBox) {
        Coords coords = boundingBox.getCoords();
        OffsetPoint northWest = new OffsetPoint(coords).offset(0.0, 0.001f, 0.0);
        OffsetPoint northEast = northWest.offset(1.0, 0.0, 0.0);
        OffsetPoint southWest = northWest.offset(0.0, 0.0, 1.0);
        Color color = BoundingBoxTypeHelper.getColor(boundingBox.getType());
        if (boundingBox.renderNorth()) {
            this.render(matrixStack, northWest, northEast, color);
        }
        if (boundingBox.renderWest()) {
            this.render(matrixStack, northWest, southWest, color);
        }
        if (ConfigManager.renderOnlyCurrentBiome.get().booleanValue()) {
            OffsetPoint southEast = southWest.offset(1.0, 0.0, 0.0);
            if (boundingBox.renderSouth()) {
                this.render(matrixStack, southWest, southEast, color);
            }
            if (boundingBox.renderEast()) {
                this.render(matrixStack, northEast, southEast, color);
            }
        }
    }

    private void render(class_4587 matrixStack, OffsetPoint topCorner1, OffsetPoint topCorner2, Color color) {
        double xOffset = 0.0;
        double zOffset = 0.0;
        if (topCorner1.getX() == topCorner2.getX()) {
            xOffset = this.getOffset(topCorner1.getX());
        } else {
            zOffset = this.getOffset(topCorner1.getZ());
        }
        topCorner1 = topCorner1.offset(xOffset, 0.0, zOffset);
        topCorner2 = topCorner2.offset(xOffset, 0.0, zOffset);
        this.renderLine(matrixStack, topCorner1, topCorner2, color, false);
        OffsetPoint bottomCorner2 = topCorner2.offset(0.0, 1.0, 0.0);
        this.renderCuboid(matrixStack, new OffsetBox(topCorner1, bottomCorner2), color, true, 30);
        OffsetPoint bottomCorner1 = topCorner1.offset(0.0, 1.0, 0.0);
        this.renderLine(matrixStack, bottomCorner1, bottomCorner2, color, false);
    }

    private double getOffset(double value) {
        return value > 0.0 ? (double)-0.001f : (double)0.001f;
    }
}

