/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.BoundingBoxLine;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.RenderQueue;
import com.irtimaled.bbor.client.renderers.Renderer;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.class_4587;

public class LineRenderer
extends AbstractRenderer<BoundingBoxLine> {
    @Override
    public void render(class_4587 matrixStack, BoundingBoxLine boundingBox) {
        Color color = BoundingBoxTypeHelper.getColor(boundingBox.getType());
        if (boundingBox.getWidth() == 0.0) {
            OffsetPoint startPoint = new OffsetPoint(boundingBox.getMinPoint()).offset(0.0, 0.001f, 0.0);
            OffsetPoint endPoint = new OffsetPoint(boundingBox.getMaxPoint()).offset(0.0, 0.001f, 0.0);
            this.renderLine(matrixStack, startPoint, endPoint, color, false);
            return;
        }
        OffsetPoint[] cornerPoints = (OffsetPoint[])Arrays.stream(boundingBox.getCorners()).map(point -> new OffsetPoint((Point)point).offset(0.0, 0.001f, 0.0)).toArray(OffsetPoint[]::new);
        RenderHelper.polygonModeLine();
        Renderer.startQuads().setMatrixStack(matrixStack).setColor(color).addPoints(cornerPoints).render();
        if (!ConfigManager.fill.get().booleanValue()) {
            return;
        }
        RenderQueue.deferRendering(() -> Renderer.startQuads().setMatrixStack(matrixStack).setColor(color).setAlpha(30).addPoints(cornerPoints).render());
    }
}

