/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.common.StructureProcessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;

public class BoundingBoxType {
    private static final Map<Integer, BoundingBoxType> structureTypeMap = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    public static final BoundingBoxType WorldSpawn = BoundingBoxType.register("World_Spawn");
    public static final BoundingBoxType SpawnChunks = BoundingBoxType.register("Spawn_Chunks");
    public static final BoundingBoxType LazySpawnChunks = BoundingBoxType.register("Lazy_Chunks");
    public static final BoundingBoxType MobSpawner = BoundingBoxType.register("Mob_Spawner");
    public static final BoundingBoxType SlimeChunks = BoundingBoxType.register("Slime_Chunks");
    public static final BoundingBoxType AFKSphere = BoundingBoxType.register("AFK Sphere");
    public static final BoundingBoxType BiomeBorder = BoundingBoxType.register("Biome Border");
    public static final BoundingBoxType Custom = BoundingBoxType.register("Custom");
    public static final BoundingBoxType Beacon = BoundingBoxType.register("Beacon");
    public static final BoundingBoxType Conduit = BoundingBoxType.register("Conduit");
    public static final BoundingBoxType SpawnableBlocks = BoundingBoxType.register("Spawnable Blocks");
    public static final BoundingBoxType FlowerForest = BoundingBoxType.register("Flower Forest");
    public static final BoundingBoxType BedrockCeiling = BoundingBoxType.register("Bedrock Ceiling");
    public static final Map<String, BoundingBoxType> structures = new HashMap<String, BoundingBoxType>();
    private final String name;

    public static BoundingBoxType register(String name) {
        return structureTypeMap.computeIfAbsent(name.hashCode(), k -> new BoundingBoxType(name));
    }

    public static void registerTypes() {
        structureTypeMap.values().forEach(StructureProcessor::registerSupportedStructure);
    }

    public static BoundingBoxType getByNameHash(Integer nameHash) {
        return structureTypeMap.get(nameHash);
    }

    private BoundingBoxType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxType other = (BoundingBoxType)obj;
        return this.name.equals(other.name);
    }
}

