/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxCuboid;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.mixin.access.IStructureStart;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

public class StructureProcessor {
    private static final Map<String, BoundingBoxType> supportedStructures = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    public static final Set<String> supportedStructureIds = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet());
    private final BoundingBoxCache boundingBoxCache;

    public static void registerSupportedStructure(BoundingBoxType type) {
        supportedStructures.put(type.getName(), type);
    }

    StructureProcessor(BoundingBoxCache boundingBoxCache) {
        this.boundingBoxCache = boundingBoxCache;
    }

    private void addStructures(BoundingBoxType type, class_3449 structureStart) {
        if (structureStart == null) {
            return;
        }
        try {
            structureStart.method_14969();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_3341 bb = ((IStructureStart)structureStart).getBoundingBox1();
        if (bb == null) {
            return;
        }
        AbstractBoundingBox boundingBox = this.buildStructure(bb, type);
        if (this.boundingBoxCache.isCached(boundingBox)) {
            return;
        }
        HashSet<AbstractBoundingBox> structureBoundingBoxes = new HashSet<AbstractBoundingBox>();
        for (class_3443 structureComponent : structureStart.method_14963()) {
            structureBoundingBoxes.add(this.buildStructure(structureComponent.method_14935(), type));
        }
        this.boundingBoxCache.addBoundingBoxes(boundingBox, structureBoundingBoxes);
    }

    private AbstractBoundingBox buildStructure(class_3341 bb, BoundingBoxType type) {
        Coords min = new Coords(bb.method_35415(), bb.method_35416(), bb.method_35417());
        Coords max = new Coords(bb.method_35418(), bb.method_35419(), bb.method_35420());
        return BoundingBoxCuboid.from(min, max, type);
    }

    void process(Map<String, class_3449> structures) {
        for (Map.Entry<String, class_3449> entry : structures.entrySet()) {
            BoundingBoxType type = supportedStructures.get("structure:" + entry.getKey());
            if (type == null) continue;
            this.addStructures(type, entry.getValue());
        }
    }
}

