/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common.interop;

import com.irtimaled.bbor.client.ClientRenderer;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.EventBus;
import com.irtimaled.bbor.common.StructureProcessor;
import com.irtimaled.bbor.common.events.PlayerLoggedIn;
import com.irtimaled.bbor.common.events.PlayerLoggedOut;
import com.irtimaled.bbor.common.events.PlayerSubscribed;
import com.irtimaled.bbor.common.events.ServerTick;
import com.irtimaled.bbor.common.events.StructuresLoaded;
import com.irtimaled.bbor.common.events.WorldLoaded;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.DimensionId;
import com.irtimaled.bbor.common.models.ServerPlayer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2535;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3449;
import net.minecraft.class_5312;
import net.minecraft.class_5321;

public class CommonInterop {
    public static void chunkLoaded(class_2818 chunk) {
        DimensionId dimensionId = DimensionId.from((class_5321<class_1937>)chunk.method_12200().method_27983());
        HashMap<String, class_3449> structures = new HashMap<String, class_3449>();
        class_2378 structureFeatureRegistry = chunk.method_12200().method_30349().method_30530(class_2378.field_25915);
        for (Map.Entry es : chunk.method_12016().entrySet()) {
            Optional optional = structureFeatureRegistry.method_29113((Object)((class_5312)es.getKey()));
            optional.ifPresent(key -> structures.put(key.method_29177().toString(), (class_3449)es.getValue()));
        }
        if (structures.size() > 0) {
            EventBus.publish(new StructuresLoaded(structures, dimensionId));
        }
    }

    public static void loadWorlds(Collection<class_3218> worlds) {
        for (class_3218 world : worlds) {
            CommonInterop.loadWorld(world);
            CommonInterop.loadWorldStructures((class_1937)world);
        }
    }

    public static void loadWorldStructures(class_1937 world) {
        class_2378 structureFeatureRegistry = world.method_30349().method_30530(class_2378.field_25915);
        System.out.println("Registring structures: " + Arrays.toString(structureFeatureRegistry.method_29722().stream().map(entry -> ((class_5321)entry.getKey()).method_29177().toString()).distinct().toArray(String[]::new)));
        for (Map.Entry entry2 : structureFeatureRegistry.method_29722()) {
            class_2960 value = ((class_5321)entry2.getKey()).method_29177();
            BoundingBoxType boundingBoxType = BoundingBoxType.register("structure:" + value);
            StructureProcessor.registerSupportedStructure(boundingBoxType);
            StructureProcessor.supportedStructureIds.add(value.toString());
            BoundingBoxTypeHelper.registerType(boundingBoxType, ConfigManager.structureShouldRender(value.toString()), ConfigManager.structureColor(value.toString()));
        }
    }

    public static void loadWorld(class_3218 world) {
        EventBus.publish(new WorldLoaded(world));
    }

    public static void tick() {
        EventBus.publish(new ServerTick());
    }

    public static void playerLoggedIn(class_3222 player) {
        class_3244 connection = player.field_13987;
        if (connection == null) {
            return;
        }
        class_2535 networkManager = connection.field_14127;
        if (networkManager.method_10756()) {
            return;
        }
        EventBus.publish(new PlayerLoggedIn(new ServerPlayer(player)));
    }

    public static void playerLoggedOut(class_3222 player) {
        EventBus.publish(new PlayerLoggedOut(player.method_5628()));
    }

    public static void playerSubscribed(class_3222 player) {
        EventBus.publish(new PlayerSubscribed(player.method_5628(), new ServerPlayer(player)));
    }

    public static <T extends AbstractBoundingBox> AbstractRenderer<T> registerRenderer(Class<? extends T> type, Supplier<AbstractRenderer<T>> renderer) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return ClientRenderer.registerRenderer(type, renderer);
        }
        return null;
    }
}

