/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common.models;

import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.CuboidRenderer;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.interop.CommonInterop;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxCuboid
extends AbstractBoundingBox {
    private static final AbstractRenderer<BoundingBoxCuboid> RENDERER = CommonInterop.registerRenderer(BoundingBoxCuboid.class, () -> new CuboidRenderer());
    private final Coords minCoords;
    private final Coords maxCoords;

    protected BoundingBoxCuboid(Coords minCoords, Coords maxCoords, BoundingBoxType type) {
        super(type);
        this.minCoords = minCoords;
        this.maxCoords = maxCoords;
    }

    public static BoundingBoxCuboid from(Coords minCoords, Coords maxCoords, BoundingBoxType type) {
        return new BoundingBoxCuboid(minCoords, maxCoords, type);
    }

    public int hashCode() {
        return TypeHelper.combineHashCodes(this.minCoords.hashCode(), this.maxCoords.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxCuboid other = (BoundingBoxCuboid)obj;
        return this.minCoords.equals(other.minCoords) && this.maxCoords.equals(other.maxCoords);
    }

    public Coords getMinCoords() {
        return this.minCoords;
    }

    public Coords getMaxCoords() {
        return this.maxCoords;
    }

    @Override
    public Boolean intersectsBounds(int minX, int minZ, int maxX, int maxZ) {
        boolean minXWithinBounds = this.isBetween(this.minCoords.getX(), minX, maxX);
        boolean maxXWithinBounds = this.isBetween(this.maxCoords.getX(), minX, maxX);
        boolean minZWithinBounds = this.isBetween(this.minCoords.getZ(), minZ, maxZ);
        boolean maxZWithinBounds = this.isBetween(this.maxCoords.getZ(), minZ, maxZ);
        return minXWithinBounds && minZWithinBounds || maxXWithinBounds && maxZWithinBounds || minXWithinBounds && maxZWithinBounds || maxXWithinBounds && minZWithinBounds;
    }

    private boolean isBetween(int val, int min, int max) {
        return val >= min && val <= max;
    }

    @Override
    public double getDistanceX(double x) {
        return x - MathHelper.clamp(x, (double)this.minCoords.getX(), (double)this.maxCoords.getX());
    }

    @Override
    public double getDistanceY(double y) {
        return y - MathHelper.clamp(y, (double)this.minCoords.getY(), (double)this.maxCoords.getY());
    }

    @Override
    public double getDistanceZ(double z) {
        return z - MathHelper.clamp(z, (double)this.minCoords.getZ(), (double)this.maxCoords.getZ());
    }

    @Override
    public AbstractRenderer<?> getRenderer() {
        return RENDERER;
    }
}

