/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget;

import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.mixin.CustomDepPredicate;
import com.plusls.MasaGadget.mixin.Dependencies;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.util.version.VersionPredicateParser;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MasaGadgetMixinPlugin
implements IMixinConfigPlugin {
    private static Method oldMatchesMethod;
    private static Method oldDisplayCriticalErrorMethod;
    private final List<String> obfuscatedMixinList = new ArrayList<String>();

    private static ClassNode loadClassNode(String className) {
        ClassNode classNode;
        try {
            classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(String.format("load ClassNode: %s fail.", className));
        }
        return classNode;
    }

    private static boolean myMatches(Version version, String s) {
        try {
            if (oldMatchesMethod != null) {
                return (Boolean)oldMatchesMethod.invoke(null, version, s);
            }
            return VersionPredicateParser.parse((String)s).test((Object)version);
        }
        catch (IllegalAccessException | InvocationTargetException | VersionParsingException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void myDisplayCriticalError(Throwable exception) {
        if (oldDisplayCriticalErrorMethod != null) {
            try {
                oldDisplayCriticalErrorMethod.invoke(null, exception, true);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            FabricGuiEntry.displayCriticalError((Throwable)exception, (boolean)true);
        }
    }

    public static boolean checkDependency(String modId, String version) {
        Optional modContainerOptional = FabricLoader.getInstance().getModContainer(modId);
        if (modContainerOptional.isPresent()) {
            ModContainer modContainer = (ModContainer)modContainerOptional.get();
            return MasaGadgetMixinPlugin.myMatches(modContainer.getMetadata().getVersion(), version);
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        FabricLoader.getInstance().getModContainer(ModInfo.MOD_ID).ifPresent(container -> container.getMetadata().getCustomValue("compat").getAsObject().forEach(customValue -> {
            if (ModInfo.isModLoaded((String)customValue.getKey()) && !MasaGadgetMixinPlugin.checkDependency((String)customValue.getKey(), ((CustomValue)customValue.getValue()).getAsString())) {
                MasaGadgetMixinPlugin.myDisplayCriticalError(new IllegalStateException(String.format("Mod %s requires: %s", customValue.getKey(), ((CustomValue)customValue.getValue()).getAsString())));
            }
        }));
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        ClassNode mixinClassNode = MasaGadgetMixinPlugin.loadClassNode(mixinClassName);
        return this.checkDependencies(mixinClassNode, targetClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return this.obfuscatedMixinList;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean checkDependency(String targetClassName, AnnotationNode dependency) {
        String modId = (String)Annotations.getValue((AnnotationNode)dependency, (String)"modId");
        List versionList = (List)Annotations.getValue((AnnotationNode)dependency, (String)"version");
        for (String version : versionList) {
            if (MasaGadgetMixinPlugin.checkDependency(modId, version)) continue;
            return false;
        }
        ClassNode targetClassNode = MasaGadgetMixinPlugin.loadClassNode(targetClassName);
        List predicateList = (List)Annotations.getValue((AnnotationNode)dependency, (String)"predicate");
        if (predicateList != null) {
            for (Type predicateType : predicateList) {
                try {
                    CustomDepPredicate predicate = Class.forName(predicateType.getClassName()).asSubclass(CustomDepPredicate.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (predicate.test(targetClassNode)) continue;
                    return false;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    ModInfo.LOGGER.warn("fuckyou");
                    throw new IllegalStateException("get CustomDepPredicate fail!");
                }
            }
        }
        return true;
    }

    public boolean checkDependencies(ClassNode mixinClassNode, String targetClassName) {
        AnnotationNode dependencies = Annotations.getInvisible((ClassNode)mixinClassNode, Dependencies.class);
        if (Annotations.getInvisible((ClassNode)mixinClassNode, Dependencies.class) != null) {
            List dependencyArray = (List)Annotations.getValue((AnnotationNode)dependencies, (String)"dependencyList");
            for (AnnotationNode dependency : dependencyArray) {
                if (this.checkDependency(targetClassName, dependency)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        try {
            oldMatchesMethod = Class.forName("net.fabricmc.loader.util.version.VersionPredicateParser").getMethod("matches", Version.class, String.class);
            oldDisplayCriticalErrorMethod = Class.forName("net.fabricmc.loader.gui.FabricGuiEntry").getMethod("displayCriticalError", Throwable.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

