/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.config.TranslatableConfigBoolean;
import com.plusls.MasaGadget.config.TranslatableConfigHotkey;
import com.plusls.MasaGadget.config.TranslatableConfigStringList;
import com.plusls.MasaGadget.gui.GuiConfigs;
import com.plusls.MasaGadget.minihud.compactBborProtocol.BborProtocol;
import com.plusls.MasaGadget.tweakeroo.pcaSyncProtocol.PcaSyncProtocol;
import com.plusls.MasaGadget.util.SearchMobSpawnPointUtil;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = ModInfo.MOD_ID + ".json";
    private static final int CONFIG_VERSION = 1;

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"generic", Generic.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"litematica", Litematica.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"malilib", Malilib.OPTIONS);
            try {
                JsonObject obj = Objects.requireNonNull(JsonUtils.getNestedObject((JsonObject)root, (String)"malilib", (boolean)true));
                JsonObject favoriteObj = Objects.requireNonNull(JsonUtils.getNestedObject((JsonObject)obj, (String)"favorites", (boolean)true));
                for (Map.Entry favoriteEntry : favoriteObj.entrySet()) {
                    HashSet modFavorites = new HashSet();
                    ((JsonElement)favoriteEntry.getValue()).getAsJsonArray().forEach(jsonElement -> modFavorites.add(jsonElement.getAsString()));
                    Malilib.FAVORITES.put((String)favoriteEntry.getKey(), modFavorites);
                }
                Malilib.favoritesFilter = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"favoritesFilter", (boolean)false);
            }
            catch (ClassCastException | IllegalStateException runtimeException) {
                // empty catch block
            }
            ConfigUtils.readConfigBase((JsonObject)root, (String)"minihud", Minihud.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"tweakeroo", Tweakeroo.OPTIONS);
        }
        if (Generic.DEBUG.getBooleanValue()) {
            Configurator.setLevel((String)ModInfo.LOGGER.getName(), (Level)Level.toLevel((String)"DEBUG"));
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"litematica", Litematica.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"malilib", Malilib.OPTIONS);
            JsonObject obj = Objects.requireNonNull(JsonUtils.getNestedObject((JsonObject)root, (String)"malilib", (boolean)true));
            JsonObject favoriteObj = new JsonObject();
            for (Map.Entry<String, HashSet<String>> favoriteEntry : Malilib.FAVORITES.entrySet()) {
                JsonArray modFavoriteObj = new JsonArray();
                if (favoriteEntry.getValue().isEmpty()) continue;
                for (String modFavoriteConfigName : favoriteEntry.getValue()) {
                    modFavoriteObj.add(modFavoriteConfigName);
                }
                favoriteObj.add(favoriteEntry.getKey(), (JsonElement)modFavoriteObj);
            }
            obj.add("favorites", (JsonElement)favoriteObj);
            obj.add("favoritesFilter", (JsonElement)new JsonPrimitive(Boolean.valueOf(Malilib.favoritesFilter)));
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"minihud", Minihud.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"tweakeroo", Tweakeroo.OPTIONS);
            root.add("configVersion", (JsonElement)new JsonPrimitive((Number)1));
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class Generic {
        private static final String PREFIX = String.format("%s.config.generic", ModInfo.MOD_ID);
        public static final ConfigHotkey OPEN_CONFIG_GUI = new TranslatableConfigHotkey(PREFIX, "openConfigGui", "G,C");
        public static final ConfigHotkey SEARCH_MOB_SPAWN_POINT = new TranslatableConfigHotkey(PREFIX, "searchMobSpawnPoint", ";");
        public static final ConfigStringList SEARCH_MOB_SPAWN_POINT_BLACK_LIST = new TranslatableConfigStringList(PREFIX, "searchMobSpawnPointBlackList", (ImmutableList<String>)ImmutableList.of());
        public static final ConfigHotkey SYNC_ALL_ENTITY_DATA = new TranslatableConfigHotkey(PREFIX, "syncAllEntityData", "");
        public static final ImmutableList<ConfigHotkey> HOTKEYS = ImmutableList.of((Object)OPEN_CONFIG_GUI, (Object)SEARCH_MOB_SPAWN_POINT, (Object)SYNC_ALL_ENTITY_DATA);
        public static final ConfigBoolean DEBUG = new TranslatableConfigBoolean(PREFIX, "debug", false);
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)OPEN_CONFIG_GUI, (Object)SEARCH_MOB_SPAWN_POINT, (Object)SEARCH_MOB_SPAWN_POINT_BLACK_LIST, (Object)SYNC_ALL_ENTITY_DATA, (Object)DEBUG);
        public static final List<IConfigBase> GUI_OPTIONS = new LinkedList<IConfigBase>((Collection<IConfigBase>)OPTIONS);

        static {
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == SEARCH_MOB_SPAWN_POINT && !ModInfo.isModLoaded("minihud"));
            OPEN_CONFIG_GUI.getKeybind().setCallback((keyAction, iKeybind) -> {
                GuiBase.openGui((class_437)new GuiConfigs());
                return true;
            });
            SEARCH_MOB_SPAWN_POINT.getKeybind().setCallback((keyAction, iKeybind) -> {
                if (ModInfo.isModLoaded("minihud")) {
                    SearchMobSpawnPointUtil.search();
                }
                return true;
            });
            DEBUG.setValueChangeCallback(config -> {
                if (config.getBooleanValue()) {
                    Configurator.setLevel((String)ModInfo.LOGGER.getName(), (Level)Level.toLevel((String)"DEBUG"));
                } else {
                    Configurator.setLevel((String)ModInfo.LOGGER.getName(), (Level)Level.toLevel((String)"INFO"));
                }
            });
            SYNC_ALL_ENTITY_DATA.getKeybind().setCallback((keyAction, iKeybind) -> {
                if (!PcaSyncProtocol.enable) {
                    return true;
                }
                class_310 mc = class_310.method_1551();
                for (class_1297 entity : Objects.requireNonNull(mc.field_1687).method_18112()) {
                    PcaSyncProtocol.syncEntity(entity.method_5628());
                }
                class_2588 text = new class_2588("masa_gadget_mod.message.syncAllEntityDataSuccess");
                text.method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)));
                Objects.requireNonNull(mc.field_1724).method_7353((class_2561)text, false);
                return true;
            });
        }
    }

    public static class Litematica {
        private static final String PREFIX = String.format("%s.config.litematica", ModInfo.MOD_ID);
        public static final ConfigBoolean BETTER_EASY_PLACE_MODE = new TranslatableConfigBoolean(PREFIX, "betterEasyPlaceMode", false);
        public static final ConfigBoolean DISABLE_LITEMATICA_EASY_PLACE_FAIL_TIP = new TranslatableConfigBoolean(PREFIX, "disableLitematicaEasyPlaceFailTip", false);
        public static final ConfigBoolean FIX_ACCURATE_PROTOCOL = new TranslatableConfigBoolean(PREFIX, "fixAccurateProtocol", true);
        public static final ConfigBoolean SAVE_INVENTORY_TO_SCHEMATIC_IN_SERVER = new TranslatableConfigBoolean(PREFIX, "saveInventoryToSchematicInServer", false);
        public static final ConfigBoolean USE_RELATIVE_PATH = new TranslatableConfigBoolean(PREFIX, "useRelativePath", false);
        public static final List<IConfigBase> OPTIONS = ImmutableList.of((Object)BETTER_EASY_PLACE_MODE, (Object)FIX_ACCURATE_PROTOCOL, (Object)DISABLE_LITEMATICA_EASY_PLACE_FAIL_TIP, (Object)SAVE_INVENTORY_TO_SCHEMATIC_IN_SERVER, (Object)USE_RELATIVE_PATH);
        public static final List<IConfigBase> GUI_OPTIONS = new LinkedList<IConfigBase>(OPTIONS);
    }

    public static class Malilib {
        public static final HashMap<String, HashSet<String>> FAVORITES = new HashMap();
        private static final String PREFIX = String.format("%s.config.malilib", ModInfo.MOD_ID);
        public static final ConfigBoolean FAST_SWITCH_MASA_CONFIG_GUI = new TranslatableConfigBoolean(PREFIX, "fastSwitchMasaConfigGui", true);
        public static final ConfigBoolean FAVORITES_SUPPORT = new TranslatableConfigBoolean(PREFIX, "favoritesSupport", false);
        public static final ConfigBoolean SHOW_ORIGINAL_CONFIG_NAME = new TranslatableConfigBoolean(PREFIX, "showOriginalConfigName", false);
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)FAST_SWITCH_MASA_CONFIG_GUI, (Object)FAVORITES_SUPPORT, (Object)SHOW_ORIGINAL_CONFIG_NAME);
        public static final List<IConfigBase> GUI_OPTIONS = new LinkedList<IConfigBase>((Collection<IConfigBase>)OPTIONS);
        public static boolean favoritesFilter;

        static {
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == FAST_SWITCH_MASA_CONFIG_GUI && !ModInfo.isModLoaded("modmenu"));
            FAVORITES_SUPPORT.setValueChangeCallback(configBoolean -> {
                if (class_310.method_1551().field_1755 instanceof GuiConfigs) {
                    ((GuiConfigs)class_310.method_1551().field_1755).refresh();
                }
            });
        }
    }

    public static class Minihud {
        private static final String PREFIX = String.format("%s.config.minihud", ModInfo.MOD_ID);
        public static final ConfigBoolean COMPACT_BBOR_PROTOCOL = new TranslatableConfigBoolean(PREFIX, "compactBborProtocol", true);
        public static final ConfigBoolean PCA_SYNC_PROTOCOL_SYNC_BEEHIVE = new TranslatableConfigBoolean(PREFIX, "pcaSyncProtocolSyncBeehive", true);
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)COMPACT_BBOR_PROTOCOL, (Object)PCA_SYNC_PROTOCOL_SYNC_BEEHIVE);
        public static final List<IConfigBase> GUI_OPTIONS = new LinkedList<IConfigBase>((Collection<IConfigBase>)OPTIONS);

        static {
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == PCA_SYNC_PROTOCOL_SYNC_BEEHIVE && !ModInfo.isModLoaded("tweakeroo"));
            COMPACT_BBOR_PROTOCOL.setValueChangeCallback(config -> {
                if (config.getBooleanValue()) {
                    class_638 world = class_310.method_1551().field_1687;
                    if (world == null) {
                        return;
                    }
                    BborProtocol.bborInit(world.method_27983().method_29177());
                }
            });
        }
    }

    public static class Tweakeroo {
        private static final String PREFIX = String.format("%s.config.tweakeroo", ModInfo.MOD_ID);
        public static final ConfigBoolean AUTO_SYNC_TRADE_OFFER_LIST = new TranslatableConfigBoolean(PREFIX, "autoSyncTradeOfferList", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_COMPARATOR = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportComparator", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_LARGE_BARREL = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportLargeBarrel", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_PLAYER = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportPlayer", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_SELECT = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportSelect", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_SHULKER_BOX_ITEM_ENTITY = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportShulkerBoxItemEntity", true);
        public static final ConfigBoolean INVENTORY_PREVIEW_SUPPORT_TRADE_OFFER_LIST = new TranslatableConfigBoolean(PREFIX, "inventoryPreviewSupportTradeOfferList", true);
        public static final ConfigBoolean PCA_SYNC_PROTOCOL = new TranslatableConfigBoolean(PREFIX, "pcaSyncProtocol", true);
        public static final ConfigBoolean RENDER_NEXT_RESTOCK_TIME = new TranslatableConfigBoolean(PREFIX, "renderNextRestockTime", false);
        public static final ConfigBoolean RENDER_TRADE_ENCHANTED_BOOK = new TranslatableConfigBoolean(PREFIX, "renderTradeEnchantedBook", false);
        public static final ConfigBoolean RENDER_ZOMBIE_VILLAGER_CONVERT_TIME = new TranslatableConfigBoolean(PREFIX, "renderZombieVillagerConvertTime", false);
        public static final ConfigBoolean RESTOCK_WITH_CRAFTING = new TranslatableConfigBoolean(PREFIX, "restockWithCrafting", false);
        public static final ConfigStringList RESTOCK_WITH_CRAFTING_RECIPES = new TranslatableConfigStringList(PREFIX, "restockWithCraftingRecipes", (ImmutableList<String>)ImmutableList.of());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)AUTO_SYNC_TRADE_OFFER_LIST, (Object)INVENTORY_PREVIEW_SUPPORT_COMPARATOR, (Object)INVENTORY_PREVIEW_SUPPORT_LARGE_BARREL, (Object)INVENTORY_PREVIEW_SUPPORT_PLAYER, (Object)INVENTORY_PREVIEW_SUPPORT_SELECT, (Object)INVENTORY_PREVIEW_SUPPORT_SHULKER_BOX_ITEM_ENTITY, (Object)INVENTORY_PREVIEW_SUPPORT_TRADE_OFFER_LIST, (Object)PCA_SYNC_PROTOCOL, (Object)RENDER_NEXT_RESTOCK_TIME, (Object)RENDER_TRADE_ENCHANTED_BOOK, (Object)RENDER_ZOMBIE_VILLAGER_CONVERT_TIME, (Object)RESTOCK_WITH_CRAFTING, (Object[])new IConfigBase[]{RESTOCK_WITH_CRAFTING_RECIPES});
        public static final List<IConfigBase> GUI_OPTIONS = new LinkedList<IConfigBase>((Collection<IConfigBase>)OPTIONS);

        static {
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == INVENTORY_PREVIEW_SUPPORT_LARGE_BARREL && !ModInfo.isModLoaded("carpet-tis-addition"));
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == RESTOCK_WITH_CRAFTING && !ModInfo.isModLoaded("litematica"));
            GUI_OPTIONS.removeIf(iConfigBase -> iConfigBase == RESTOCK_WITH_CRAFTING_RECIPES && !ModInfo.isModLoaded("litematica"));
        }
    }
}

