/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.gui;

import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.config.Configs;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;

public class GuiConfigs
extends GuiConfigsBase {
    public static ConfigGuiTab tab = ConfigGuiTab.GENERIC;

    public GuiConfigs() {
        super(10, 50, ModInfo.MOD_ID, null, StringUtils.translate((String)String.format("%s.gui.title.configs", ModInfo.MOD_ID), (Object[])new Object[]{ModInfo.MOD_VERSION}), new Object[0]);
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        int rows = 1;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            if (!ModInfo.isModLoaded("litematica") && tab == ConfigGuiTab.LITEMATICA || !ModInfo.isModLoaded("minihud") && tab == ConfigGuiTab.MINIHUD || !ModInfo.isModLoaded("tweakeroo") && tab == ConfigGuiTab.TWEAKEROO) continue;
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.field_22789 - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createButton(x, y, width, tab);
        }
        if (rows > 1) {
            int scrollbarPosition = Objects.requireNonNull((WidgetListConfigOptions)this.getListWidget()).getScrollbar().getValue();
            this.setListPosition(this.getListX(), 50 + (rows - 1) * 22);
            this.reCreateListWidget();
            ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().setValue(scrollbarPosition);
            ((WidgetListConfigOptions)this.getListWidget()).refreshEntries();
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListenerConfigTabs(tab, this));
        return button.getWidth() + 2;
    }

    public void refresh() {
        WidgetListConfigOptions widgetListConfigOptions = (WidgetListConfigOptions)this.getListWidget();
        if (widgetListConfigOptions != null) {
            widgetListConfigOptions.getScrollbar().setValue(0);
            widgetListConfigOptions.refreshEntries();
        }
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        List<IConfigBase> configs;
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.Generic.GUI_OPTIONS;
        } else if (tab == ConfigGuiTab.LITEMATICA) {
            configs = Configs.Litematica.GUI_OPTIONS;
        } else if (tab == ConfigGuiTab.MALILIB) {
            configs = Configs.Malilib.GUI_OPTIONS;
        } else if (tab == ConfigGuiTab.MINIHUD) {
            configs = Configs.Minihud.GUI_OPTIONS;
        } else if (tab == ConfigGuiTab.TWEAKEROO) {
            configs = Configs.Tweakeroo.GUI_OPTIONS;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        GENERIC("generic"),
        LITEMATICA("litematica"),
        MALILIB("malilib"),
        MINIHUD("minihud"),
        TWEAKEROO("tweakeroo");

        private final String name;

        private ConfigGuiTab(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return class_1074.method_4662((String)String.format("%s.gui.button.configGui.%s", ModInfo.MOD_ID, this.name), (Object[])new Object[0]);
        }
    }

    private static class ButtonListenerConfigTabs
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListenerConfigTabs(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            Objects.requireNonNull((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

