/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.minihud.compactBborProtocol;

import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.config.Configs;
import com.plusls.MasaGadget.event.DisconnectEvent;
import com.plusls.MasaGadget.minihud.compactBborProtocol.BoundingBoxDeserializer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.StructureType;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.earthcomputer.multiconnect.api.MultiConnectAPI;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class BborProtocol {
    public static final String NAMESPACE = "bbor";
    public static final ReentrantLock lock = new ReentrantLock(true);
    public static final Map<class_2960, class_2499> structuresCache = new ConcurrentHashMap<class_2960, class_2499>();
    private static final class_2960 INITIALIZE = BborProtocol.id("initialize");
    private static final class_2960 ADD_BOUNDING_BOX_V2 = BborProtocol.id("add_bounding_box_v2");
    private static final class_2960 SUBSCRIBE = BborProtocol.id("subscribe");
    private static final HashMap<Integer, String> BBOR_ID_TO_MINIHUD_ID = new HashMap();
    public static Long seedCache = null;
    public static class_2338 spawnPos = null;
    public static boolean enable = false;
    public static boolean carpetOrServux = false;

    private static class_2960 id(String path) {
        return new class_2960(NAMESPACE, path);
    }

    public static String lowVersionStructureName(String name) {
        CharSequence[] splitResult = name.split("_");
        for (int i = 0; i < splitResult.length; ++i) {
            splitResult[i] = ((String)splitResult[i]).substring(0, 1).toUpperCase() + ((String)splitResult[i]).substring(1);
        }
        return String.join((CharSequence)"_", splitResult);
    }

    public static void init() {
        DisconnectEvent.register(BborProtocol::onDisconnect);
        MultiConnectAPI.instance().addClientboundIdentifierCustomPayloadListener(event -> {
            class_2960 channel = (class_2960)event.getChannel();
            BborProtocol.bborProtocolHandler(event.getNetworkHandler(), channel, event.getData());
        });
        MultiConnectAPI.instance().addServerboundIdentifierCustomPayloadListener(event -> {
            class_2960 channel = (class_2960)event.getChannel();
            if (channel.equals((Object)SUBSCRIBE)) {
                ModInfo.LOGGER.debug("Multiconnect send bbor:SUBSCRIBE");
                MultiConnectAPI.instance().forceSendCustomPayload(event.getNetworkHandler(), (class_2960)event.getChannel(), event.getData());
            }
        });
    }

    private static void onDisconnect() {
        ModInfo.LOGGER.info("BborProtocol onDisconnect");
        seedCache = null;
        spawnPos = null;
        structuresCache.clear();
        enable = false;
        carpetOrServux = false;
    }

    public static void bborProtocolHandler(class_634 clientPlayNetworkHandler, class_2960 channel, class_2540 data) {
        try {
            if (channel.equals((Object)INITIALIZE)) {
                BborProtocol.onDisconnect();
                BborProtocol.bborInitializeHandler(clientPlayNetworkHandler, data);
            } else if (channel.equals((Object)ADD_BOUNDING_BOX_V2)) {
                BborProtocol.bborAddBoundingBoxV2Handler(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void bborInitializeHandler(class_634 clientPlayNetworkHandler, class_2540 data) {
        long seed = data.readLong();
        int spawnX = data.readInt();
        int spawnZ = data.readInt();
        seedCache = seed;
        spawnPos = new class_2338(spawnX, 0, spawnZ);
        if (!carpetOrServux) {
            enable = true;
            if (Configs.Minihud.COMPACT_BBOR_PROTOCOL.getBooleanValue()) {
                BborProtocol.initMetaData();
            }
            ModInfo.LOGGER.info("init seed: {}", (Object)seedCache);
            if (!ModInfo.isModLoaded(NAMESPACE)) {
                ModInfo.LOGGER.debug("SUBSCRIBE BBOR.");
                clientPlayNetworkHandler.method_2883((class_2596)new class_2817(SUBSCRIBE, new class_2540(Unpooled.buffer())));
            }
        }
    }

    public static void bborInit(class_2960 dimensionId) {
        BborProtocol.initMetaData();
        BborProtocol.bborRefreshData(dimensionId);
    }

    public static void initMetaData() {
        if (seedCache != null) {
            DataStorage.getInstance().setWorldSeed(seedCache.longValue());
        }
        if (spawnPos != null) {
            DataStorage.getInstance().setWorldSpawn(spawnPos);
        }
    }

    public static void bborRefreshData(class_2960 dimensionId) {
        if (!structuresCache.containsKey(dimensionId)) {
            structuresCache.put(dimensionId, new class_2499());
        }
        lock.lock();
        try {
            DataStorage.getInstance().addOrUpdateStructuresFromServer(structuresCache.get(dimensionId), 0x7FFFEFFF, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        lock.unlock();
    }

    private static void bborAddBoundingBoxV2Handler(class_2540 data) {
        BborProtocol.parse(data);
    }

    public static String bborIdToMinihudId(int bborId) {
        return BBOR_ID_TO_MINIHUD_ID.getOrDefault(bborId, "");
    }

    public static void parse(class_2540 buf) {
        class_2960 dimensionId = buf.method_10810();
        ModInfo.LOGGER.debug("dimensionId = {}", (Object)dimensionId.toString());
        class_2487 tag = BoundingBoxDeserializer.deserializeStructure(buf);
        if (!structuresCache.containsKey(dimensionId)) {
            structuresCache.put(dimensionId, new class_2499());
        }
        if (tag != null) {
            structuresCache.get(dimensionId).add((Object)tag);
            if (enable && Configs.Minihud.COMPACT_BBOR_PROTOCOL.getBooleanValue() && class_310.method_1551().field_1687 != null) {
                lock.lock();
                try {
                    DataStorage.getInstance().addOrUpdateStructuresFromServer(structuresCache.get(dimensionId), 0x7FFFEFFF, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                lock.unlock();
            }
        }
    }

    static {
        for (StructureType type : StructureType.VALUES) {
            String structureName = type.getStructureName();
            class_2960 key = type.getFeatureId();
            if (key == null) continue;
            BBOR_ID_TO_MINIHUD_ID.put(structureName.hashCode(), key.toString());
            BBOR_ID_TO_MINIHUD_ID.put(BborProtocol.lowVersionStructureName(structureName).hashCode(), key.toString());
        }
    }
}

