/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.tweakeroo.pcaSyncProtocol;

import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.config.Configs;
import com.plusls.MasaGadget.event.DisconnectEvent;
import com.plusls.MasaGadget.litematica.saveInventoryToSchematicInServer.PcaSyncUtil;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import io.netty.buffer.Unpooled;
import net.earthcomputer.multiconnect.api.ICustomPayloadEvent;
import net.earthcomputer.multiconnect.api.ICustomPayloadListener;
import net.earthcomputer.multiconnect.api.MultiConnectAPI;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1496;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3988;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class PcaSyncProtocol {
    private static final String NAMESPACE = "pca";
    private static final class_2960 SYNC_BLOCK_ENTITY = PcaSyncProtocol.id("sync_block_entity");
    private static final class_2960 SYNC_ENTITY = PcaSyncProtocol.id("sync_entity");
    private static final class_2960 CANCEL_SYNC_REQUEST_BLOCK_ENTITY = PcaSyncProtocol.id("cancel_sync_block_entity");
    private static final class_2960 CANCEL_SYNC_ENTITY = PcaSyncProtocol.id("cancel_sync_entity");
    private static final class_2960 ENABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("enable_pca_sync_protocol");
    private static final class_2960 DISABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("disable_pca_sync_protocol");
    private static final class_2960 UPDATE_ENTITY = PcaSyncProtocol.id("update_entity");
    private static final class_2960 UPDATE_BLOCK_ENTITY = PcaSyncProtocol.id("update_block_entity");
    private static final ClientboundIdentifierCustomPayloadListener clientboundIdentifierCustomPayloadListener = new ClientboundIdentifierCustomPayloadListener();
    private static final ServerboundIdentifierCustomPayloadListener serverboundIdentifierCustomPayloadListener = new ServerboundIdentifierCustomPayloadListener();
    public static boolean enable = false;
    private static class_2338 lastBlockPos = null;
    private static int lastEntityId = -1;

    private static class_2960 id(String path) {
        return new class_2960(NAMESPACE, path);
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENABLE_PCA_SYNC_PROTOCOL, PcaSyncProtocol::enablePcaSyncProtocolHandle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_PCA_SYNC_PROTOCOL, PcaSyncProtocol::disablePcaSyncProtocolHandle);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_ENTITY, PcaSyncProtocol::updateEntityHandler);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_BLOCK_ENTITY, PcaSyncProtocol::updateBlockEntityHandler);
        DisconnectEvent.register(PcaSyncProtocol::onDisconnect);
        MultiConnectAPI.instance().addClientboundIdentifierCustomPayloadListener((ICustomPayloadListener)clientboundIdentifierCustomPayloadListener);
        MultiConnectAPI.instance().addServerboundIdentifierCustomPayloadListener((ICustomPayloadListener)serverboundIdentifierCustomPayloadListener);
    }

    private static void onDisconnect() {
        ModInfo.LOGGER.info("pcaSyncProtocol onDisconnect.");
        enable = false;
    }

    private static void enablePcaSyncProtocolHandle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (!client.method_1496()) {
            ModInfo.LOGGER.info("pcaSyncProtocol enable.");
            enable = true;
        }
    }

    private static void disablePcaSyncProtocolHandle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (!client.method_1496()) {
            ModInfo.LOGGER.info("pcaSyncProtocol disable.");
            enable = false;
        }
    }

    private static void updateEntityHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1937 world = player.field_6002;
        if (!world.method_27983().method_29177().equals((Object)buf.method_10810())) {
            return;
        }
        int entityId = buf.readInt();
        class_2487 tag = buf.method_10798();
        class_1297 entity = world.method_8469(entityId);
        if (entity != null) {
            ModInfo.LOGGER.debug("update entity!");
            assert (tag != null);
            if (entity instanceof class_1308 && tag.method_10577("PersistenceRequired")) {
                ((class_1308)entity).method_5971();
            }
            if (entity instanceof class_1693) {
                ((class_1693)entity).field_7735.clear();
                class_1262.method_5429((class_2487)tag, (class_2371)((class_1693)entity).field_7735);
            } else if (entity instanceof class_3988) {
                ((class_3988)entity).method_18011().method_5448();
                ((class_3988)entity).method_18011().method_7659(tag.method_10554("Inventory", 10));
                ((class_3988)entity).field_17721 = new class_1916(tag.method_10562("Offers"));
                if (entity instanceof class_1646) {
                    ((class_1646)entity).field_19427 = tag.method_10550("RestocksToday");
                    ((class_1646)entity).field_18537 = tag.method_10537("LastRestock");
                }
            } else if (entity instanceof class_1496) {
                entity.method_5651(tag);
            } else if (entity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)entity;
                playerEntity.method_31548().method_7397(tag.method_10554("Inventory", 10));
                if (tag.method_10573("EnderItems", 9)) {
                    playerEntity.method_7274().method_7659(tag.method_10554("EnderItems", 10));
                }
            } else if (entity instanceof class_1641 && tag.method_10573("ConversionTime", 99) && tag.method_10550("ConversionTime") > -1) {
                ((class_1641)entity).method_7199(tag.method_25928("ConversionPlayer") ? tag.method_25926("ConversionPlayer") : null, tag.method_10550("ConversionTime"));
            }
        }
    }

    private static void updateBlockEntityHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1937 world = player.field_6002;
        if (!world.method_27983().method_29177().equals((Object)buf.method_10810())) {
            return;
        }
        class_2338 pos = buf.method_10811();
        class_2487 tag = buf.method_10798();
        class_2586 blockEntity = world.method_8321(pos);
        if (Configs.Litematica.SAVE_INVENTORY_TO_SCHEMATIC_IN_SERVER.getBooleanValue() && pos.equals((Object)PcaSyncUtil.lastUpdatePos)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"masa_gadget_mod.message.loadInventoryToLocalSuccess", (Object[])new Object[0]);
        }
        if (blockEntity != null) {
            ModInfo.LOGGER.debug("update blockEntity!");
            blockEntity.method_11014(tag);
        }
    }

    public static void syncBlockEntity(class_2338 pos) {
        if (lastBlockPos != null && lastBlockPos.equals((Object)pos)) {
            return;
        }
        ModInfo.LOGGER.debug("syncBlockEntity: {}", (Object)pos);
        lastBlockPos = pos;
        lastEntityId = -1;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(pos);
        ClientPlayNetworking.send((class_2960)SYNC_BLOCK_ENTITY, (class_2540)buf);
    }

    public static void syncEntity(int entityId) {
        if (lastEntityId != -1 && lastEntityId == entityId) {
            return;
        }
        ModInfo.LOGGER.debug("syncEntity: {}", (Object)entityId);
        lastEntityId = entityId;
        lastBlockPos = null;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(entityId);
        ClientPlayNetworking.send((class_2960)SYNC_ENTITY, (class_2540)buf);
    }

    public static void cancelSyncBlockEntity() {
        if (lastBlockPos == null) {
            return;
        }
        lastBlockPos = null;
        ModInfo.LOGGER.debug("cancelSyncBlockEntity.");
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)CANCEL_SYNC_REQUEST_BLOCK_ENTITY, (class_2540)buf);
    }

    public static void cancelSyncEntity() {
        if (lastEntityId == -1) {
            return;
        }
        lastEntityId = -1;
        ModInfo.LOGGER.debug("cancelSyncEntity.");
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)CANCEL_SYNC_ENTITY, (class_2540)buf);
    }

    private static class ClientboundIdentifierCustomPayloadListener
    implements ICustomPayloadListener<class_2960> {
        private ClientboundIdentifierCustomPayloadListener() {
        }

        public void onCustomPayload(ICustomPayloadEvent<class_2960> event) {
            class_2960 channel = (class_2960)event.getChannel();
            if (channel.equals((Object)ENABLE_PCA_SYNC_PROTOCOL)) {
                PcaSyncProtocol.enablePcaSyncProtocolHandle(class_310.method_1551(), null, event.getData(), null);
            } else if (channel.equals((Object)DISABLE_PCA_SYNC_PROTOCOL)) {
                PcaSyncProtocol.disablePcaSyncProtocolHandle(class_310.method_1551(), null, event.getData(), null);
            } else if (channel.equals((Object)UPDATE_ENTITY)) {
                PcaSyncProtocol.updateEntityHandler(class_310.method_1551(), null, event.getData(), null);
            } else if (channel.equals((Object)UPDATE_BLOCK_ENTITY)) {
                PcaSyncProtocol.updateBlockEntityHandler(class_310.method_1551(), null, event.getData(), null);
            }
        }
    }

    private static class ServerboundIdentifierCustomPayloadListener
    implements ICustomPayloadListener<class_2960> {
        private ServerboundIdentifierCustomPayloadListener() {
        }

        public void onCustomPayload(ICustomPayloadEvent<class_2960> event) {
            class_2960 channel = (class_2960)event.getChannel();
            if (channel.equals((Object)SYNC_BLOCK_ENTITY)) {
                MultiConnectAPI.instance().forceSendCustomPayload(event.getNetworkHandler(), (class_2960)event.getChannel(), event.getData());
            } else if (channel.equals((Object)SYNC_ENTITY)) {
                MultiConnectAPI.instance().forceSendCustomPayload(event.getNetworkHandler(), (class_2960)event.getChannel(), event.getData());
            } else if (channel.equals((Object)CANCEL_SYNC_REQUEST_BLOCK_ENTITY)) {
                MultiConnectAPI.instance().forceSendCustomPayload(event.getNetworkHandler(), (class_2960)event.getChannel(), event.getData());
            } else if (channel.equals((Object)CANCEL_SYNC_ENTITY)) {
                MultiConnectAPI.instance().forceSendCustomPayload(event.getNetworkHandler(), (class_2960)event.getChannel(), event.getData());
            }
        }
    }
}

