/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.util;

import com.plusls.MasaGadget.ModInfo;
import com.plusls.MasaGadget.config.Configs;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeDespawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class SearchMobSpawnPointUtil {
    @Nullable
    private static ShapeDespawnSphere getShapeDespawnSphere() {
        ShapeDespawnSphere ret = null;
        for (ShapeBase shapeBase : ShapeManager.INSTANCE.getAllShapes()) {
            if (!shapeBase.isEnabled() || !(shapeBase instanceof ShapeDespawnSphere)) continue;
            if (ret == null) {
                ret = (ShapeDespawnSphere)shapeBase;
                continue;
            }
            Objects.requireNonNull(class_310.method_1551().field_1724).method_7353((class_2561)new class_2588("masa_gadget_mod.message.onlySupportOneDespawnShape").method_27692(class_124.field_1061), false);
            return null;
        }
        if (ret == null) {
            Objects.requireNonNull(class_310.method_1551().field_1724).method_7353((class_2561)new class_2588("masa_gadget_mod.message.canNotFindDespawnShape").method_27692(class_124.field_1061), false);
        }
        return ret;
    }

    public static void search() {
        class_5250 text;
        class_638 world = class_310.method_1551().field_1687;
        class_746 player = class_310.method_1551().field_1724;
        if (world == null || player == null) {
            return;
        }
        ShapeDespawnSphere shapeDespawnSphere = SearchMobSpawnPointUtil.getShapeDespawnSphere();
        if (shapeDespawnSphere == null) {
            return;
        }
        class_243 centerPos = shapeDespawnSphere.getCenter();
        class_2338 pos = new class_2338((int)centerPos.field_1352, (int)centerPos.field_1351, (int)centerPos.field_1350);
        ModInfo.LOGGER.warn("shape: {}", (Object)shapeDespawnSphere.getCenter());
        class_2338.class_2339 spawnPos = null;
        int maxX = pos.method_10263() + 129;
        int maxZ = pos.method_10260() + 129;
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        int maxSpawnLightLevel = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        class_3568 lightingProvider = world.method_2935().method_12130();
        class_1299 entityType = world.method_8597().method_27999() ? class_1299.field_6050 : class_1299.field_6046;
        class_1299 entityType2 = world.method_8597().method_27999() ? null : class_1299.field_6079;
        for (int x = pos.method_10263() - 129; x <= maxX; ++x) {
            block1: for (int z = pos.method_10260() - 129; z <= maxZ; ++z) {
                class_2818 chunk = world.method_8497(x >> 4, z >> 4);
                if (chunk == null) continue;
                int maxY = Math.min(pos.method_10264() + 129, chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1);
                for (int y = Math.max(pos.method_10264() - 129, world.method_31607() + 1); y <= maxY; ++y) {
                    if (SearchMobSpawnPointUtil.squaredDistanceTo(x, y, z, centerPos) > 16384.0) {
                        if (!((double)y > centerPos.field_1351)) continue;
                        continue block1;
                    }
                    if (spawnPos != null && player.method_5649((double)x, (double)y, (double)z) > player.method_5649((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260())) continue;
                    currentPos.method_10103(x, y, z);
                    if (!class_1948.method_8660((class_1317.class_1319)class_1317.method_6159((class_1299)entityType), (class_4538)world, (class_2338)currentPos, (class_1299)entityType) || lightingProvider.method_15562(class_1944.field_9282).method_15543((class_2338)currentPos) >= maxSpawnLightLevel) continue;
                    class_2248 block = world.method_8320(currentPos.method_10074()).method_26204();
                    String blockId = class_2378.field_11146.method_10221((Object)world.method_8320(currentPos.method_10074()).method_26204()).toString();
                    String blockName = block.method_9518().getString();
                    if (!Configs.Generic.SEARCH_MOB_SPAWN_POINT_BLACK_LIST.getStrings().stream().noneMatch(s -> blockId.contains((CharSequence)s) || blockName.contains((CharSequence)s))) continue;
                    if (world.method_18026(entityType.method_17683((double)currentPos.method_10263() + 0.5, (double)currentPos.method_10264(), (double)currentPos.method_10260() + 0.5))) {
                        spawnPos = currentPos.method_25503();
                        continue;
                    }
                    if (entityType2 == null || !world.method_18026(entityType2.method_17683((double)currentPos.method_10263() + 0.5, (double)currentPos.method_10264(), (double)currentPos.method_10260() + 0.5))) continue;
                    spawnPos = currentPos.method_25503();
                }
            }
        }
        if (spawnPos == null) {
            text = new class_2588("masa_gadget_mod.message.noBlockCanSpawn").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)));
        } else {
            text = new class_2585(class_1074.method_4662((String)"masa_gadget_mod.message.spawnPos", (Object[])new Object[]{spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()}));
            player.method_3142(String.format("/highlightWaypoint %d %d %d", spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260()));
        }
        Objects.requireNonNull(class_310.method_1551().field_1724).method_7353((class_2561)text, false);
    }

    private static double squaredDistanceTo(int x, int y, int z, class_243 vec3d) {
        double d = vec3d.field_1352 - (double)x;
        double e = vec3d.field_1351 - (double)y;
        double f = vec3d.field_1350 - (double)z;
        return d * d + e * e + f * f;
    }
}

