/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;

public class ModContainer
implements net.fabricmc.loader.api.ModContainer {
    private final LoaderModMetadata info;
    private final URL originUrl;
    private Path root;

    public ModContainer(LoaderModMetadata info, URL originUrl) {
        this.info = info;
        this.originUrl = originUrl;
    }

    void setupRootPath() {
        if (this.root != null) {
            throw new RuntimeException("Not allowed to setup mod root path twice!");
        }
        try {
            Path holder = UrlUtil.asPath(this.originUrl).toAbsolutePath();
            if (Files.isDirectory(holder, new LinkOption[0])) {
                this.root = holder.toAbsolutePath();
            } else {
                FileSystemUtil.FileSystemDelegate delegate = FileSystemUtil.getJarFileSystem(holder, false);
                if (delegate.get() == null) {
                    throw new RuntimeException("Could not open JAR file " + holder.getFileName() + " for NIO reading!");
                }
                this.root = delegate.get().getRootDirectories().iterator().next();
            }
        }
        catch (IOException | UrlConversionException e) {
            throw new RuntimeException("Failed to find root directory for mod '" + this.info.getId() + "'!", e);
        }
    }

    @Override
    public ModMetadata getMetadata() {
        return this.info;
    }

    @Override
    public Path getRootPath() {
        if (this.root == null) {
            throw new RuntimeException("Accessed mod root before primary loader!");
        }
        return this.root;
    }

    public LoaderModMetadata getInfo() {
        return this.info;
    }

    public URL getOriginUrl() {
        return this.originUrl;
    }
}

