/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint.minecraft;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.fabricmc.loader.entrypoint.EntrypointPatch;
import net.fabricmc.loader.entrypoint.EntrypointTransformer;
import net.fabricmc.loader.launch.common.FabricLauncher;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class EntrypointPatchBranding
extends EntrypointPatch {
    public EntrypointPatchBranding(EntrypointTransformer transformer) {
        super(transformer);
    }

    @Override
    public void process(FabricLauncher launcher, Consumer<ClassNode> classEmitter) {
        for (String brandClassName : ImmutableList.of((Object)"net.minecraft.client.ClientBrandRetriever", (Object)"net.minecraft.server.MinecraftServer")) {
            try {
                ClassNode brandClass = this.loadClass(launcher, brandClassName);
                if (brandClass == null || !this.applyBrandingPatch(brandClass)) continue;
                classEmitter.accept(brandClass);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean applyBrandingPatch(ClassNode classNode) {
        boolean applied = false;
        for (MethodNode node : classNode.methods) {
            if (!node.name.equals("getClientModName") && (!node.name.equals("getServerModName") || !node.desc.endsWith(")Ljava/lang/String;"))) continue;
            this.debug("Applying brand name hook to " + classNode.name + "::" + node.name);
            ListIterator it = node.instructions.iterator();
            while (it.hasNext()) {
                if (((AbstractInsnNode)it.next()).getOpcode() != 176) continue;
                it.previous();
                it.add(new MethodInsnNode(184, "net/fabricmc/loader/entrypoint/minecraft/hooks/EntrypointBranding", "brand", "(Ljava/lang/String;)Ljava/lang/String;", false));
                it.next();
            }
            applied = true;
        }
        return applied;
    }
}

