/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint.minecraft;

import java.io.IOException;
import java.util.function.Consumer;
import net.fabricmc.loader.entrypoint.EntrypointPatch;
import net.fabricmc.loader.entrypoint.EntrypointTransformer;
import net.fabricmc.loader.launch.common.FabricLauncher;
import net.fabricmc.loader.launch.knot.Knot;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;

public class EntrypointPatchFML125
extends EntrypointPatch {
    private static final String FROM = "net.fabricmc.loader.entrypoint.patches.ModClassLoader_125_FML";
    private static final String TO = "cpw.mods.fml.common.ModClassLoader";
    private static final String FROM_INTERNAL = "net/fabricmc/loader/entrypoint/minecraft/ModClassLoader_125_FML";
    private static final String TO_INTERNAL = "cpw/mods/fml/common/ModClassLoader";

    public EntrypointPatchFML125(EntrypointTransformer transformer) {
        super(transformer);
    }

    @Override
    public void process(FabricLauncher launcher, Consumer<ClassNode> classEmitter) {
        if (this.classExists(launcher, TO) && !this.classExists(launcher, "cpw.mods.fml.relauncher.FMLRelauncher")) {
            if (!(launcher instanceof Knot)) {
                throw new RuntimeException("1.2.5 FML patch only supported on Knot!");
            }
            this.debug("Detected 1.2.5 FML - Knotifying ModClassLoader...");
            try {
                ClassNode patchedClassLoader = this.loadClass(launcher, FROM);
                ClassNode remappedClassLoader = new ClassNode();
                patchedClassLoader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)remappedClassLoader, new Remapper(){

                    public String map(String internalName) {
                        return EntrypointPatchFML125.FROM_INTERNAL.equals(internalName) ? EntrypointPatchFML125.TO_INTERNAL : internalName;
                    }
                }));
                classEmitter.accept(remappedClassLoader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

