/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.common;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.common.MappingConfiguration;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.util.mappings.MixinIntermediaryDevRemapper;
import net.fabricmc.mapping.tree.TinyTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public final class FabricMixinBootstrap {
    protected static Logger LOGGER = LogManager.getFormatterLogger((String)"Fabric|MixinBootstrap");
    private static boolean initialized = false;

    private FabricMixinBootstrap() {
    }

    static void addConfiguration(String configuration) {
        Mixins.addConfiguration((String)configuration);
    }

    static Set<String> getMixinConfigs(FabricLoader loader, EnvType type) {
        return loader.getAllMods().stream().map(ModContainer::getMetadata).filter(m -> m instanceof LoaderModMetadata).flatMap(m -> ((LoaderModMetadata)m).getMixinConfigs(type).stream()).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toSet());
    }

    public static void init(EnvType side, FabricLoader loader) {
        List namespaces;
        MappingConfiguration mappingConfiguration;
        TinyTree mappings;
        if (initialized) {
            throw new RuntimeException("FabricMixinBootstrap has already been initialized!");
        }
        if (FabricLauncherBase.getLauncher().isDevelopment() && (mappings = (mappingConfiguration = FabricLauncherBase.getLauncher().getMappingConfiguration()).getMappings()) != null && (namespaces = mappings.getMetadata().getNamespaces()).contains("intermediary") && namespaces.contains(mappingConfiguration.getTargetNamespace())) {
            System.setProperty("mixin.env.remapRefMap", "true");
            try {
                MixinIntermediaryDevRemapper remapper = new MixinIntermediaryDevRemapper(mappings, "intermediary", mappingConfiguration.getTargetNamespace());
                MixinEnvironment.getDefaultEnvironment().getRemappers().add((IRemapper)remapper);
                LOGGER.info("Loaded Fabric development mappings for mixin remapper!");
            }
            catch (Exception e) {
                LOGGER.error("Fabric development environment setup error - the game will probably crash soon!");
                e.printStackTrace();
            }
        }
        MixinBootstrap.init();
        FabricMixinBootstrap.getMixinConfigs(loader, side).forEach(FabricMixinBootstrap::addConfiguration);
        initialized = true;
    }
}

