/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.knot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.knot.KnotClassLoaderInterface;
import net.fabricmc.loader.transformer.FabricTransformer;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import org.spongepowered.asm.mixin.transformer.FabricMixinTransformerProxy;

class KnotClassDelegate {
    private final Map<String, Metadata> metadataCache = new HashMap<String, Metadata>();
    private final KnotClassLoaderInterface itf;
    private final GameProvider provider;
    private final boolean isDevelopment;
    private final EnvType envType;
    private FabricMixinTransformerProxy mixinTransformer;
    private boolean transformInitialized = false;

    KnotClassDelegate(boolean isDevelopment, EnvType envType, KnotClassLoaderInterface itf, GameProvider provider) {
        this.isDevelopment = isDevelopment;
        this.envType = envType;
        this.itf = itf;
        this.provider = provider;
    }

    public void initializeTransformers() {
        if (this.transformInitialized) {
            throw new RuntimeException("Cannot initialize KnotClassDelegate twice!");
        }
        this.mixinTransformer = new FabricMixinTransformerProxy();
        this.transformInitialized = true;
    }

    private FabricMixinTransformerProxy getMixinTransformer() {
        assert (this.mixinTransformer != null);
        return this.mixinTransformer;
    }

    Metadata getMetadata(String name, URL resourceURL) {
        if (resourceURL != null) {
            URL codeSourceURL = null;
            String filename = name.replace('.', '/') + ".class";
            try {
                codeSourceURL = UrlUtil.getSource(filename, resourceURL);
            }
            catch (UrlConversionException e) {
                System.err.println("Could not find code source for " + resourceURL + ": " + e.getMessage());
            }
            if (codeSourceURL != null) {
                return this.metadataCache.computeIfAbsent(codeSourceURL.toString(), codeSourceStr -> {
                    URL fCodeSourceUrl;
                    Certificate[] certificates;
                    CodeSource codeSource;
                    Manifest manifest;
                    block28: {
                        manifest = null;
                        codeSource = null;
                        certificates = null;
                        fCodeSourceUrl = null;
                        try {
                            fCodeSourceUrl = new URL((String)codeSourceStr);
                            Path path = UrlUtil.asPath(fCodeSourceUrl);
                            if (!Files.isRegularFile(path, new LinkOption[0])) break block28;
                            URLConnection connection = new URL("jar:" + codeSourceStr + "!/").openConnection();
                            if (connection instanceof JarURLConnection) {
                                manifest = ((JarURLConnection)connection).getManifest();
                                certificates = ((JarURLConnection)connection).getCertificates();
                            }
                            if (manifest != null) break block28;
                            try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(path, false);){
                                Path manifestPath = jarFs.get().getPath("META-INF/MANIFEST.MF", new String[0]);
                                if (!Files.exists(manifestPath, new LinkOption[0])) break block28;
                                try (InputStream stream = Files.newInputStream(manifestPath, new OpenOption[0]);){
                                    manifest = new Manifest(stream);
                                }
                            }
                        }
                        catch (IOException | FileSystemNotFoundException | UrlConversionException e) {
                            if (!FabricLauncherBase.getLauncher().isDevelopment()) break block28;
                            System.err.println("Failed to load manifest: " + e);
                            e.printStackTrace();
                        }
                    }
                    if (codeSource == null) {
                        codeSource = new CodeSource(fCodeSourceUrl, certificates);
                    }
                    return new Metadata(manifest, codeSource);
                });
            }
        }
        return Metadata.EMPTY;
    }

    public byte[] loadClassData(String name, boolean resolve) {
        if (!this.transformInitialized) {
            try {
                return this.getClassByteArray(name, true);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load class file for '" + name + "'!", e);
            }
        }
        if (!name.startsWith("org.apache.logging.log4j")) {
            byte[] input = this.provider.getEntrypointTransformer().transform(name);
            if (input == null) {
                try {
                    input = this.getClassByteArray(name, true);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load class file for '" + name + "'!", e);
                }
            }
            if (input != null) {
                byte[] b = FabricTransformer.transform(this.isDevelopment, this.envType, name, input);
                b = this.getMixinTransformer().transformClassBytes(name, name, b);
                return b;
            }
        }
        return this.getMixinTransformer().transformClassBytes(name, name, null);
    }

    String getClassFileName(String name) {
        return name.replace('.', '/') + ".class";
    }

    public byte[] getClassByteArray(String name, boolean skipOriginalLoader) throws IOException {
        int len;
        String classFile = this.getClassFileName(name);
        InputStream inputStream = this.itf.getResourceAsStream(classFile, skipOriginalLoader);
        if (inputStream == null) {
            return null;
        }
        int a = inputStream.available();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(a < 32 ? 32768 : a);
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    static class Metadata {
        static final Metadata EMPTY = new Metadata(null, null);
        final Manifest manifest;
        final CodeSource codeSource;

        Metadata(Manifest manifest, CodeSource codeSource) {
            this.manifest = manifest;
            this.codeSource = codeSource;
        }
    }
}

